% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BRBVS.R
\name{BRBVS}
\alias{BRBVS}
\title{Bivariate Rank-Based Variable Selection}
\usage{
BRBVS(y, x, kmax, copula, margins, m, tau, n.rep, metric)
}
\arguments{
\item{y}{Time to events and censoring matrix as a data frame.}

\item{x}{Covariates matrix as a data frame. Input matrix containing the predictor variables.}

\item{kmax}{Numeric. The maximum number of variables to be selected. Must be positive, non-zero, and
less than or equal to the number of columns in \code{x}.}

\item{copula}{Character. Type of copula employed in the algorithm. Must be one of the following types:
\code{N}, \code{C0}, \code{C90}, \code{C180}, \code{C270}, \code{GAL0}, \code{GAL90}, \code{GAL180}, \code{GAL270},
\code{J0}, \code{J90}, \code{J180}, \code{J270}, \code{G0}, \code{G90}, \code{G180}, \code{G270}, \code{F}, \code{AMH},
\code{FGM}, \code{T}, \code{PL}, \code{HO} default is \code{C0}.
See GJRM package documentation for details: \href{https://CRAN.R-project.org/package=GJRM}{GJRM package}.}

\item{margins}{Character. Type of margin employed in the algorithm. Must be one of \code{PH}, \code{PO}, \code{probit}.
Default is c(\code{PH}, \code{PO}).
See GJRM package documentation for more on margins: \href{https://CRAN.R-project.org/package=GJRM}{GJRM package}.}

\item{m}{Numeric. Subsample size, typically set to n/2 where n is the number of observations.}

\item{tau}{Numeric. A user-defined threshold for variable selection. Must be in the interval (0,1), exclusive.}

\item{n.rep}{Integer. Number of Bootstrap replicates. Must be positive.}

\item{metric}{Character, specifies the metric used for ranking the variables.
Must be one of 'CE', 'FIM', 'Abs'. Default is 'FIM'.}
}
\value{
A list containing the following components:
\itemize{
\item \code{mtx.act1E}: Numeric vector of indices of the active variables selected based on the first survival function. Remaining positions (up to 'kmax') are filled with 0.
\item \code{score.r1E}: Numeric vector of the ranked scores for variable selection based on the first survival function, with remaining positions (up to 'kmax'-1) filled with 0.
\item \code{freq.rel1E}: Numeric vector of the relative frequencies of selected variables based on the first survival function (frequencies divided by 'n.rep').
\item \code{mtx.act2E}: Numeric vector of indices of the active variables selected based on the second survival function. Remaining positions (up to 'kmax') are filled with 0.
\item \code{score.r2E}: Numeric vector of the ranked scores for variable selection based on the second survival function, with remaining positions (up to 'kmax'-1) filled with 0.
\item \code{freq.rel2E}: Numeric vector of the relative frequencies of selected variables based on the second survival function (frequencies divided by 'n.rep').
\item \code{metric}: The metric used for ranking the variables.
\item \code{kmax}: The maximum number of variables to be selected.
\item \code{copula}: The type of copula employed in the algorithm.
\item \code{margins}: The type of margins employed in the algorithm.
.  - \code{Namecondings}: Table with name of covariates and encoding used in the output.
}
}
\description{
This function performs bivariate rank-based variable selection (BRBVS) based on copula survival copula models.
It computes rankings for covariates and selects a specified number of variables according to the estimated probabilities.
The function returns rankings and selected variables for different criteria.
}
\examples{

###############################################
# Example based on AREDS dataset
# This analysis serves solely as a
# demonstration of the function's capabilities.
###############################################
\donttest{
data(AREDS)
Y<- AREDS[,c('t11','t12', 't21', 't22', 'cens1', 'cens2', 'cens')]
X<- AREDS[,c(3, 9)]
# Including just 1 covariates as example
X$SevScale1E <- scale(as.numeric( X$SevScale1E))
X$SevScale2E <- scale(as.numeric(X$SevScale1E))


Bivrbvs<- BRBVS(y=Y, x=X, kmax=2,copula='C0',
                      margins=c('PO','PO'),
                      m=628 , # try to set m=628 (628 is the sample size)
                      tau=0.5,
                      n.rep=1, # number of bootstrap = 1
                      metric='FIM')
                      }






}
