% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/renewal_tools.R
\name{compareToGLM}
\alias{compareToGLM}
\title{Compare renewals fit to glm models fit}
\usage{
compareToGLM(poisson_model, breaks, nbinom_model, ...)
}
\arguments{
\item{poisson_model}{fitted Poisson glm model}

\item{breaks}{integer values at which the breaks should happen. The function
will compute the observed frequencies in the intervals \code{[breaks[i],
breaks[i + 1])}.}

\item{nbinom_model}{fitted negative binomial (fitted using
\code{MASS::glm.nb()}). This argument is optional.}

\item{...}{renewal models to be considered.}
}
\value{
data.frame with columns \code{Counts}, \code{Actual} (observed
    probability) and then 2 columns per model passed (predicted probability
    and pearson statistic) for the associated count value.
}
\description{
Compare renewals fit to glm models fit on the same data.
}
\details{
This function computes a data.frame similar to Table 5.6 in Cameron(2013),
using the observed frequencies and predictions from different
models. Supported models accepted are Poisson and negative binomial (fitted
using \code{MASS::glm.nb()}) from the glm family and any model from the
renewal family (passed in \code{...}).
}
\references{
\insertRef{cameron2013regression}{Countr}
}
