% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/default_params_doc.R
\name{default_params_doc}
\alias{default_params_doc}
\title{Documentation for function in the DAISIEprep package}
\usage{
default_params_doc(
  island_colonist,
  island_tbl,
  phylod,
  extraction_method,
  species_label,
  species_endemicity,
  x,
  value,
  clade_name,
  status,
  missing_species,
  col_time,
  col_max_age,
  branching_times,
  min_age,
  species,
  clade_type,
  endemic_clade,
  phylo,
  island_species,
  descendants,
  clade,
  asr_method,
  tie_preference,
  earliest_col,
  include_not_present,
  nested_asr_species,
  num_missing_species,
  species_to_add_to,
  node_pies,
  test_scenario,
  data,
  island_age,
  num_mainland_species,
  num_clade_types,
  list_type2_clades,
  prop_type2_pool,
  epss,
  verbose,
  precise_col_time,
  n,
  digits,
  include_crown_age,
  only_tips,
  node_label,
  multi_phylod,
  island_tbl_1,
  island_tbl_2,
  unique_clade_name,
  genus_name,
  stem,
  genus_in_tree,
  missing_genus,
  checklist,
  phylo_name_col,
  genus_name_col,
  in_phylo_col,
  endemicity_status_col,
  rm_species_col,
  tree_size_range,
  num_points,
  prob_on_island,
  prob_endemic,
  replicates,
  log_scale,
  parameter_index,
  sse_model,
  force_nonendemic_singleton,
  ...
)
}
\arguments{
\item{island_colonist}{An instance of the \code{Island_colonist} class.}

\item{island_tbl}{An instance of the \code{Island_tbl} class.}

\item{phylod}{A \code{phylo4d} object from the package \code{phylobase} containing
phylogenetic and endemicity data for each species.}

\item{extraction_method}{A character string specifying whether the
colonisation time extracted is the minimum time (\code{min}) (before the present),
or the most probable time under ancestral state reconstruction (\code{asr}).}

\item{species_label}{The tip label of the species of interest.}

\item{species_endemicity}{A character string with the endemicity, either
"endemic" or "nonendemic" of an island species, or "not_present" if not on
the island.}

\item{x}{An object whose class is determined by the signature.}

\item{value}{A value which can take several forms to be assigned to an object
of a class.}

\item{clade_name}{Character name of the colonising clade.}

\item{status}{Character endemicity status of the colonising clade. Either
\code{"endemic"} or \code{"nonendemic"}.}

\item{missing_species}{Numeric number of missing species from the phylogeny
that belong to the colonising clade. For a clade with missing species this
is \eqn{n - 1}, where \eqn{n} is the number of missing species in the clade.
If the clade is an island singleton, the number of missing species is \code{0}
because by adding the colonist it already counts as one automatically. If
the clade has more than one species, the \code{missing_species} is \eqn{n - 1}
because adding the lineage already counts as one.}

\item{col_time}{Numeric with the colonisation time of the island colonist}

\item{col_max_age}{Boolean determining whether colonisation time should be
considered a precise time of colonisation or a maximum time of colonisation}

\item{branching_times}{Numeric vector of one or more elements which are the
branching times on the island.}

\item{min_age}{Numeric minimum age (time before the present) that the species
must have colonised the island by. This is known when there is a branching
on the island, either in species or subspecies.}

\item{species}{Character vector of one or more elements containing the name
of the species included in the colonising clade.}

\item{clade_type}{Numeric determining which type of clade the island colonist
is, this determines which macroevolutionary regime (parameter set) the island
colonist is in. After formatting the \code{island_tbl} to a DAISIE data list, the
clade type can be used to conduct a 2-type analysis (see
\url{https://CRAN.R-project.org/package=DAISIE/vignettes/demo_optimize.html}
for more information)}

\item{endemic_clade}{Named vector with all the species from a clade.}

\item{phylo}{A phylogeny either as a \code{phylo} (from the \code{ape} package) or
\code{phylo4} (from the \code{phylobase} package) object.}

\item{island_species}{Data frame with two columns. The first is a character
string of the tip_labels with the tip names of the species on the island.
The second column a character string of the endemicity status of the species,
either endemic or nonendemic.}

\item{descendants}{A vector character strings with the names of species to
determine whether they are the same species.}

\item{clade}{A numeric vector which the indices of the species which are
in the island clade.}

\item{asr_method}{A character string, either "parsimony" or "mk" determines
whether a maximum parsimony or continuous-time markov model reconstructs the
ancestral states at each node. See documentation in
\code{\link[castor:asr_max_parsimony]{castor::asr_max_parsimony()}} or \code{\link[castor:asr_mk_model]{castor::asr_mk_model()}} in \code{castor} R
package for details on the methods used.}

\item{tie_preference}{Character string, either "island" or "mainland" to
choose the most probable state at each node using the \code{max.col()} function.
When a node has island presence and absence equally probable we need to
decide whether that species should be considered on the island. To consider
it on the island use \code{ties.method = "last"} in the \code{max.col()} function, if
you consider it not on the island use \code{ties.method = "first"}. Default is
"island".}

\item{earliest_col}{A boolean to determine whether to take the colonisation
time as the most probable time (FALSE) or the earliest possible colonisation
time (TRUE), where the probability of a species being on the island is
non-zero. Default is FALSE.}

\item{include_not_present}{A boolean determining whether species not present
on the island should be included in island colonist when embedded within an
island clade. Default is FALSE.}

\item{nested_asr_species}{A \code{character} string which determines whether
\emph{nested island colonists} are split into separate colonists (\code{"split"}), or
grouped into a single clade (\code{"group"}). Nested species are those whose tip
state is on the island, and they have ancestral nodes on the island, but
there are nodes in between these island state nodes that have the state
\code{not_present} (i.e. not on the island). Therefore, the colonisation time
can be extracted as the most recent node state on the island (this can be
the branching time before the tip if the ancestor node of the tip is not
on the island), or the older node state of the larger clade, for \code{"split"}
or \code{"group"} respectively. \strong{Note} This argument only applies when
\code{extraction_method = "asr"}.}

\item{num_missing_species}{Numeric for the number of missing species in the
clade.}

\item{species_to_add_to}{Character string with the name of the species to
identify which clade to assign missing species to.}

\item{node_pies}{Boolean determining if pie charts of the probabilities of
a species being present on the island. If TRUE the correct data is required
in the phylod object.}

\item{test_scenario}{Integer specifying which test phylod object to create.}

\item{data}{Either an object of class \code{Island_tbl} or a DAISIE data table
object (output from \code{as_daisie_datatable()}).}

\item{island_age}{Age of the island in appropriate units.}

\item{num_mainland_species}{The size of the mainland pool, i.e. the number
of species that can potentially colonise the island.}

\item{num_clade_types}{Number of clade types. Default num_clade_types = 1 all
species are considered to belong to the same macroevolutionary process. If
num_clade_types = 2, there are two types of clades with distinct
macroevolutionary processes.}

\item{list_type2_clades}{If num_clade_types = 2, list_type2_clades specifies
the names of the clades that have a distinct macroevolutionary process. The
names must match those in the "Clade_name" column of the source data table.
If num_clade_types = 1, then list_type2_clades = NA should be specified
(default).}

\item{prop_type2_pool}{Specifies the fraction of potential mainland colonists
that have a distinct macroevolutionary process. Applies only if
number_clade_types = 2. Default "proportional" sets the fraction to be
proportional to the number of clades of distinct macroevolutionary process
that have colonised the island. Alternatively, the user can specify a value
between 0 and 1 (e.g. if the mainland pool size is 1000 and prop_type2_pool
= 0.02 then the number of type 2 species is 20).}

\item{epss}{Default = 1e-5 should be appropriate in most cases. This value
is used to set the maximum age of colonisation of "Non_endemic_MaxAge" and
"Endemic_MaxAge" species to an age that is slightly younger than the island
for cases when the age provided for that species is older than the island.
The new maximum age is then used as an upper bound to integrate over all
possible colonisation times.}

\item{verbose}{Boolean. States if intermediate results should be printed to
console. Defaults to FALSE}

\item{precise_col_time}{Boolean, TRUE uses the precise times of colonisation,
FALSE makes every colonist a max age colonistion and uses minimum age of
colonisation if available.}

\item{n}{A numeric to be rounded.}

\item{digits}{A numeric specifying which decimal places to round to}

\item{include_crown_age}{A boolean determining whether the crown age gets
plotted with the stem age.}

\item{only_tips}{A boolean determing whether only the tips (i.e. terminal
branches) are searched for back colonisation events.}

\item{node_label}{A numeric label for a node within a phylogeny.}

\item{multi_phylod}{A list of phylod objects.}

\item{island_tbl_1}{An object of \code{Island_tbl} class to be comparedl}

\item{island_tbl_2}{An object of \code{Island_tbl} class to be compared}

\item{unique_clade_name}{Boolean determining whether a unique species
identifier is used as the clade name in the Island_tbl object or a genus
name which may not be unique if that genus has several independent island
colonisations}

\item{genus_name}{Character string of genus name to be matched with a genus
name from the tip labels in the phylogeny}

\item{stem}{Character string, either "genus" or "island_presence". The former
will extract the stem age of the genussbased on the genus name provided, the
latter will extract the stem age based on the ancestral presence on the
island either based on the "min" or "asr" extraction algorithms.}

\item{genus_in_tree}{A numeric vector that indicates which species in the
genus are in the tree}

\item{missing_genus}{A list of character vectors containing the genera in
each island clade}

\item{checklist}{data frame with information on species on the island}

\item{phylo_name_col}{A character string specifying the column name where the
names in the phylogeny are in the checklist}

\item{genus_name_col}{A character string specifying the column name where the
genus names are in the checklist}

\item{in_phylo_col}{A character string specifying the column name where the
status of whether a species is in the phylogeny is in the checklist}

\item{endemicity_status_col}{A character string specifying the column name
where the endemicity status of the species are in the checklist}

\item{rm_species_col}{A character string specifying the column name where
the information on whether to remove species from the checklist before
counting the number of missing species is in the checklist. This can be NULL
if no species are to be removed from the checklist. This is useful when
species are in the checklist because they are on the island but need to be
removed as they are not in the group of interest, e.g. a migratory bird
amongst terrestrial birds}

\item{tree_size_range}{Numeric vector of two elements, the first is the
smallest tree size (number of tips) and the second is the largest tree size}

\item{num_points}{Numeric determining how many points in the sequence of
smallest tree size to largest tree size}

\item{prob_on_island}{Numeric vector of each probability on island to use in
the parameter space}

\item{prob_endemic}{Numeric vector of each probability of an island species
being endemic to use in the parameter space}

\item{replicates}{Numeric determining the number of replicates to use to
account for the stochasticity in sampling the species on the island and
endemic species}

\item{log_scale}{A boolean determining whether the sequence of tree sizes
are on a linear (FALSE) or log (TRUE) scale}

\item{parameter_index}{Numeric determining which parameter set to use (i.e
which row in the parameter space data frame), if this is NULL all parameter
sets will be looped over}

\item{sse_model}{either "musse" (default) or "geosse". MuSSE expects state
values 1, 2, 3, which here we encode as "not_present", "endemic",
"nonendemic", respectively. GeoSSE expects trait values 0, 1, 2, with 0 the
widespread state (here, "nonendemic"), and 1 and 2 are "not_present" and
"endemic", respectively.}

\item{force_nonendemic_singleton}{A boolean that determines whether all
species that are classified as \code{"nonendemic"} are forced to be extracted as
singletons (i.e single species lineages). By default it is \code{FALSE} so
non-endemics can be extracted either as singletons or part of an endemic
clade. When set to \code{TRUE} all non-endemic species in the tree will be
single species colonists, with the colonisation time extracted as the stem
age for the tip in the phylogeny. There are some exceptions to this, please
see \code{vignette("Forcing_nonendemic_singleton", package = "DAISIEprep")} for more details.

This argument is only active when \code{extraction_method = "asr"}, when
\code{extraction_method = "min"} this argument will be ignored with a warning,
as the \code{min} method always extracts non-endemic species as singletons.}

\item{...}{\link{dots} Allows arguments to be passed to \code{\link[castor:asr_mk_model]{castor::asr_mk_model()}}
and \code{\link[castor:asr_max_parsimony]{castor::asr_max_parsimony()}}. These arguments must match by name
exactly, see \code{?castor::asr_mk_model()} and \code{?castor::asr_max_parsimony()}
for information on arguments.}
}
\value{
Nothing
}
\description{
Documentation for function in the DAISIEprep package
}
\author{
Joshua W. Lambert
}
