% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EValue.R
\name{evalues.HR}
\alias{evalues.HR}
\title{Compute E-value for a hazard ratio and its confidence interval limits}
\usage{
evalues.HR(est, lo = NA, hi = NA, rare = NA, true = 1)
}
\arguments{
\item{est}{The point estimate}

\item{lo}{The lower limit of the confidence interval}

\item{hi}{The upper limit of the confidence interval}

\item{rare}{1 if outcome is rare (<15 percent at end of follow-up); 0 if outcome is not rare (>15 percent at end of follow-up)}

\item{true}{The true HR to which to shift the observed point estimate. Typically set to 1 to consider a null true effect.}
}
\description{
Returns a data frame containing point estimates, the lower confidence limit, and the upper confidence limit
on the risk ratio scale (through an approximate conversion if needed when outcome is common) as well as E-values for the point estimate and the confidence interval
limit closer to the null.
}
\examples{
# compute E-value for HR = 0.56 with CI: [0.46, 0.69]
# for a common outcome
evalues.HR( 0.56, 0.46, 0.69, rare = FALSE )
}
