% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EValue_selection.R
\name{threshold_selection}
\alias{threshold_selection}
\title{Compute selection bias E-value for single value of risk ratio as well as a
statement about what parameters it refers to}
\usage{
threshold_selection(
  x,
  true = 1,
  sel_pop = FALSE,
  S_eq_U = FALSE,
  risk_inc = FALSE,
  risk_dec = FALSE,
  ...
)
}
\arguments{
\item{x}{The risk ratio}

\item{true}{The true RR to which to shift the observed point estimate.
Typically set to 1 to consider a null true effect.}

\item{sel_pop}{Whether inference is specific to selected population (TRUE) or
entire population (FALSE). Defaults to FALSE.}

\item{S_eq_U}{Whether the unmeasured factor is assumed to be a defining
characteristic of the selected population. Defaults to FALSE.}

\item{risk_inc}{Whether selection is assumed to be associated with increased
risk of the outcome in both exposure groups. Defaults to FALSE.}

\item{risk_dec}{Whether selection is assumed to be associated with decreased
risk of the outcome in both exposure groups. Defaults to FALSE.}
}
\description{
Computes selection bias E-value for a single value of the risk ratio. Users
should typically call the relevant \code{svalues.XX()} function rather than
this internal function.
}
\keyword{internal}
