% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fe_yield_table_methods.R
\name{stocking_level}
\alias{stocking_level}
\title{Calculate the Stocking Level ("Bestockungsgrad") of a Stand}
\usage{
stocking_level(ba, age, si, ytable)
}
\arguments{
\item{ba}{The stand's basal area in m²/ha}

\item{age}{The stand's age in years}

\item{si}{The stand's site index according to the yield table \code{yt}}

\item{ytable}{The yield table to be used as reference. Must be an object
of class \code{\link{fe_yield_table}}}
}
\value{
The stocking level of the stand based on the yield table of interest
}
\description{
The stocking level (German "Bestockungsgrad") is an important measure for
stand density in practice. It is the ratio of a stand's actual basal area
and its expected basal area due to a yield table.
}
\examples{
  # Scots pine stand, 72 years old, site index 1.2, basal area 41.3 m²/ha

  # 1. Reference: Yield table for pine by Wiedemann
  stocking_level(
    ba = 41.3, age = 72, si = 1.2,
    ytable = fe_ytable_pine_wiedemann_moderate_1943
  )

  # 2. Reference: Yield table for pine by Wiedemann
  stocking_level(
    ba = 41.3, age = 72, si = 1.2,
    ytable = fe_ytable_pine_gehrhardt_moderate_1921
  )

  # Norway spruce stand, 72 years old, site index 38, basal area 41.3 m²/ha
  # 1. Reference Yield Table by Assmann-Franz
  stocking_level(
    ba = 41.3, age = 72, si = 38,
    ytable = fe_ytable_spruce_assmann_franz_mean_yield_level_1963
  )

  # 2. Reference Yield Table for spruce by Wiedemann, moderate thinning,
  # site index 1.0
  stocking_level(
    ba = 41.3, age = 72, si = 1.0,
    ytable = fe_ytable_spruce_wiedemann_moderate_1936_42
  )


}
\seealso{
Other yield table functions: 
\code{\link{fe_yield_table}()},
\code{\link{plot.fe_yield_table}()},
\code{\link{si_to_mai_age}()},
\code{\link{si_to_mai_max}()},
\code{\link{site_index}()},
\code{\link{yield_tables_for_species}},
\code{\link{ytable_age_slice}()},
\code{\link{ytable_lookup}()},
\code{\link{ytable_max_slice}()}
}
\concept{yield table functions}
