% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Script_PLATE_03_COMPUTE_PSI_2_Compute_MXE.R
\name{ComputePSI.MXE}
\alias{ComputePSI.MXE}
\title{Compute mutually exclusive exons (MXE) percent spliced-in (PSI) values}
\usage{
ComputePSI.MXE(MarvelObject, CoverageThreshold, UnevenCoverageMultiplier = 10)
}
\arguments{
\item{MarvelObject}{Marvel object. S3 object generated from \code{CreateMarvelObject} function.}

\item{CoverageThreshold}{Numeric value. Coverage threshold below which the PSI of the splicing event will be censored, i.e. annotated as missing (NA). Coverage defined as the total number of reads supporting both included and excluded isoforms.}

\item{UnevenCoverageMultiplier}{Numeric value. Maximum allowable fold difference between two included or two excluded junction counts for MXE.}
}
\value{
An object of class S3 with new slots \code{$SpliceFeatureValidated$MXE} and \code{$PSI$MXE}.
}
\description{
Validate MXE splicing events and subsequently computes percent spliced-in (PSI) values these high-quality splicing events.
}
\details{
This function computes the PSI for each MXE splicing event. Splicing events provided in \code{SpliceFeature} data frame will first be cross-checked against the splice junctions provided in \code{SpliceJunction} data frame. Only events whose junctions are found in \code{SpliceJunction} are retained. The formula for computing PSI is the number of junction reads supporting the included isoform divided by the total number of reads supporting both included and excluded isoforms.
}
\examples{
marvel.demo <- readRDS(system.file("extdata/data", "marvel.demo.rds", package="MARVEL"))

marvel.demo <- ComputePSI.MXE(MarvelObject=marvel.demo,
                              CoverageThreshold=10,
                              UnevenCoverageMultiplier=10
                              )
}
\author{
Sean Wen <sean.wenwx@gmail.com>
}
