% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/olink_normalization_product.R
\name{olink_normalization_bridgeable}
\alias{olink_normalization_bridgeable}
\title{Identify if assays shared between Olink Explore 3072 and Olink Explore HT can
be bridged}
\usage{
olink_normalization_bridgeable(lst_df, ref_cols, not_ref_cols, seed = 1)
}
\arguments{
\item{lst_df}{A named list of the 2 input datasets. First element should be
the reference dataset from Olink Explore HT and the second element should
originate from Olink Explore 3072.}

\item{ref_cols}{A named list with the column names to use. Exported from
olink_norm_input_check.}

\item{not_ref_cols}{A named list with the column names from the non-reference
dataset. Exported from olink_norm_input_check.}

\item{seed}{Integer random seed (Default: seek = 1).}
}
\value{
A "tibble" in long format with the following columns:
\itemize{
\item{OlinkID:} Underscore-separated Olink identifiers of matching assays
between Olink Explore HT and Olink Explore 3072.
\item{BridgingRecommendation:} A character vector indicating whether the
matching assays are considered as bridgeable or not, and the recommended
type of normalization to perform.
}
}
\description{
The function uses a dataset from Olink Explore 3072 and a dataset from Olink
Explore HT, and examines if the matched assays between the two products can
be normalized to each other. The input datasets should be exported from Olink
software and should not be altered prior to importing them to this function.
}
\details{
All processes below assume that the first element from \var{lst_df} is the
reference dataset (e.g. Olink Explore HT), and the other element of the list
is the non-reference dataset (e.g. Olink Explore 3072). The input datasets
\strong{have to be pre-processed} by \code{\link{olink_norm_input_check}}
which will take care of mapping of assay identifiers and various checks.
Also, the input datasets should exclusively contain datapoints from bridge
samples. When this function is called from the function
\code{\link{olink_normalization}}, then the list is created seamlessly in the
background, and the datasets have been already processed by
\code{\link{olink_norm_input_check}}.

The input \var{ref_cols} is a named list masking column names of the
reference dataset. This list is generated automatically from
\code{\link{olink_norm_input_check}} when it is called from
\code{\link{olink_normalization}}. In addition,
\code{\link{olink_normalization}} has also utilized
\code{\link{norm_internal_rename_cols}} to rename the columns of the
non-reference dataset according to the ones of the reference dataset, hence
all column names should match.
}
\examples{
\donttest{
# check input datasets
data_explore_check <- OlinkAnalyze:::olink_norm_input_check(
  df1 = OlinkAnalyze:::data_3k_small,
  df2 = OlinkAnalyze:::data_ht_small,
  overlapping_samples_df1 = intersect(
    x = unique(OlinkAnalyze:::data_3k_small$SampleID),
    y = unique(OlinkAnalyze:::data_ht_small$SampleID)
  ) |>
    (\(x) x[!grepl("CONTROL", x)])() |>
    head(20L),
  overlapping_samples_df2 = NULL,
  df1_project_nr = "P1",
  df2_project_nr = "P2",
  reference_project = "P2",
  reference_medians = NULL
)

# create lst_df
lst_df <- list(
  data_explore_check$ref_df,
  data_explore_check$not_ref_df
)
names(lst_df) <- c(data_explore_check$ref_name,
                   data_explore_check$not_ref_name)

# create ref_cols
ref_cols <- data_explore_check$ref_cols
not_ref_cols <- data_explore_check$not_ref_cols

# run olink_normalization_bridgeable
is_bridgeable_result <- OlinkAnalyze:::olink_normalization_bridgeable(
  lst_df = lst_df,
  ref_cols = ref_cols,
  not_ref_cols = not_ref_cols,
  seed = 1
)
}

}
\author{
Amrita Kar
Marianne Sandin
Danai G. Topouza
Klev Diamanti
}
\keyword{Bridging}
\keyword{NPX}
