\name{PBSddesolve}
\alias{PBSddesolve-package}
\alias{PBSddesolve}
\docType{package}
\title{
  Package: Solver for Delay Differential Equations
}
\description{
  A solver for systems of delay differential equations based on 
  numerical routines from Simon Wood's
  \href{https://www.maths.ed.ac.uk/~swood34/simon/dde.html}{\code{solv95}} program. 
  This solver is also capable of solving systems of ordinary
  differential equations.
}
\details{
  Please see the user guide \code{PBSddesolve-UG.pdf}, located in R's
  library directory \code{./library/PBSddesolve/doc}, for a 
  comprehensive overview.
}
\author{
  \href{mailto:alex@mofo.ca}{Alex Couture-Beil} -- Software Engineer, Earthly Technologies, Victoria BC\cr
  \href{mailto:schnutej@shaw.ca}{Jon T. Schnute} -- Scientist Emeritus, DFO, Nanaimo BC\cr
  \href{mailto:nboers@gmail.com}{Nicholas M. Boers} -- Senior Software Engineer, Jobber, Edmonton AB

  Maintainer: \href{mailto:rowan.haigh@dfo-mpo.gc.ca}{Rowan Haigh}, Program Head -- Offshore Rockfish\cr
  Pacific Biological Station (PBS), Fisheries & Oceans Canada (DFO), Nanaimo BC\cr
  \emph{locus opus}: Regional Headquarters (RHQ), Vancouver BC\cr
  Last modified \code{Rd: 2023-01-30}
}
\references{
  Wood, S.N. (1999) Solv95: a numerical solver for systems of delay 
  differential equations with switches. Saint Andrews, UK. 10 pp.
}

\seealso{
  \code{\link[PBSddesolve]{dde}}
}
\keyword{package}

