% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny_app_functions.R
\name{buildTooltipOrPopoverOptionsList}
\alias{buildTooltipOrPopoverOptionsList}
\title{Custom tooltip function}
\usage{
buildTooltipOrPopoverOptionsList(title, placement, trigger, options, content)
}
\arguments{
\item{title}{The text for the tooltip's title.}

\item{placement}{Placement of the tooltip. One of 'top', 'bottom', 'left', or 'right'.}

\item{trigger}{The events that trigger the tooltip. One or more of 'click', 'hover', 'focus', or 'manual'.}

\item{options}{A list of additional options for the tooltip.}

\item{content}{Optional HTML content for the tooltip.}
}
\value{
A list of tooltip options to be used in the Shiny application.
}
\description{
This function creates a custom tooltip for a given element in a Shiny application.
The implementation is based on the shinyBS package.
}
\examples{
\dontrun{
tooltip_options <- custom_tooltip(
  title = "Sample tooltip",
  placement = "top",
  trigger = "hover",
  options = list(delay = 100),
  content = "This is a custom tooltip."
)

# In a Shiny app
# shiny::tags$span("Hover me!", `data-toggle` = "tooltip",
                   `data-placement` = "top", `data-trigger` = "hover",
                   `title` = "Hello, tooltip!")
}
}
\seealso{
\url{https://CRAN.R-project.org/package=shinyBS}
}
\keyword{internal}
\keyword{shiny_app}
