% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Get_School2mun.R
\name{Get_School2mun}
\alias{Get_School2mun}
\title{Associate a Municipality (LAU) code to each school}
\source{
\href{https://dati.istruzione.it/opendata/opendata/catalogo/elements1/leaf/?area=Edilizia+Scolastica&datasetId=DS0101EDIANAGRAFESTA2021}{Buildings registry (2021 onwards)};
 \href{https://dati.istruzione.it/opendata/opendata/catalogo/elements1/leaf/?area=Edilizia+Scolastica&datasetId=DS0200EDIANAGRAFESTA}{Buindings registry(until 2019)};
  \href{https://dati.istruzione.it/opendata/opendata/catalogo/elements1/?area=Scuole}{Schools registry}
}
\usage{
Get_School2mun(
  Year = 2023,
  show_col_types = FALSE,
  verbose = TRUE,
  input_AdmUnNames = NULL,
  input_Registry = NULL,
  autoAbort = FALSE
)
}
\arguments{
\item{Year}{Numeric or character value (last available is 2023).
Available in the formats: \code{2023}, \code{"2022/2023"}, \code{202223}, \code{20222023.} \code{2023} by default.}

\item{show_col_types}{Logical. If \code{TRUE}, if the \code{verbose} argument is also \code{TRUE}, the columns of the raw dataset are shown during the download. \code{FALSE} by default.}

\item{verbose}{Logical. If \code{TRUE}, the user keeps track of the main underlying operations. \code{TRUE} by default.}

\item{input_AdmUnNames}{Object of class \code{tbl_df}, \code{tbl} and \code{data.frame}, obtained as output of the function \code{\link{Get_AdmUnNames}}
The ISTAT file including all the administrative units codes for the year in scope.
If \code{NULL}, it will be downloaded automatically, but not saved in the global environment. \code{NULL} by default.}

\item{input_Registry}{Object of class \code{tbl_df}, \code{tbl} and \code{data.frame}, obtained as output of the function \code{\link{Get_Registry}}
The school registry corresonding to the year in scope.
If \code{NULL}, it will be downloaded automatically, but not saved in the global environment.
\code{NULL} by default}

\item{autoAbort}{Logical. Whether to automatically abort the operation and return NULL in case of missing internet connection or server response errors. \code{FALSE} by default.}
}
\value{
An object of class \code{list}, including 4 elements:
\itemize{
  \item \code{$Registry_from_buildings}: Object of class \code{tbl_df}, \code{tbl} and \code{data.frame}: the schools listed in the buildings registry
  \item \code{$Registry_from_registry}: Object of class \code{tbl_df}, \code{tbl} and \code{data.frame}: the schools listed in the schools registry
  \item \code{$Any}: Object of class \code{tbl_df}, \code{tbl} and \code{data.frame}: schools listed anywhere
  \item \code{$Both}: Object of class \code{tbl_df}, \code{tbl} and \code{data.frame}: schools listed in both the sections

}
}
\description{
This function associates the relevant municipality codes to all the schools listed in the two main registries provided by the Italian Ministry of Education, University and Research, namely:
 \itemize{
   \item The registry of school buildings, here referred to as \code{Registry_from_buildings} (\code{\link{Get_DB_MIUR}})
   \item The official schools registry, here referred to as \code{Registry_from_registry} (see \code{\link{Get_Registry}})
 }
}
\examples{

\donttest{
Get_School2mun(Year = 2023, autoAbort = TRUE)
}


}
