% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.software.R
\name{check.software}
\alias{check.software}
\title{Check SOFTWARE.bib Against Global Packages}
\usage{
check.software(full = FALSE)
}
\arguments{
\item{full}{whether to return full data frame as output.}
}
\value{
Logical vector (or data frame if \verb{full = TRUE}) indicating which
installed packages are \dfn{ready}, i.e., at least as new as the version
required in \verb{SOFTWARE.bib}.

A warning is generated if any installed packages are older than required.
}
\description{
Compare versions declared in \verb{SOFTWARE.bib} with packages installed in
the global R library.
}
\note{
Generally, TAF installs R packages that are declared in \verb{SOFTWARE.bib}
inside the TAF library (\verb{boot/library}). This guarantees that the right
versions of packages are installed for the analysis. The \code{taf.library}
function is then used to load packages from the TAF library.

In special cases, however, it might be useful to compare the versions of
packages declared in \verb{SOFTWARE.bib} against packages that are installed
in the global R library, outside the TAF library.
}
\examples{
\dontrun{
check.software()
check.software(full=TRUE)
}

}
\seealso{
\code{\link{taf.boot}} and \code{\link{taf.library}} are the general tools to
install and load packages of the correct version in the TAF library.

\code{\link{update.packages}} can be used to update packages in the general R
library to the newest version available on CRAN.
}
