% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalise.r
\name{normalise}
\alias{normalise}
\title{Create normalised database schemas from functional dependencies}
\usage{
normalise(
  dependencies,
  single_ref = FALSE,
  ensure_lossless = TRUE,
  reduce_attributes = TRUE,
  remove_avoidable = FALSE,
  constants_name = "constants",
  progress = FALSE,
  progress_file = ""
)
}
\arguments{
\item{dependencies}{a \code{\link{functional_dependency}} object, as given by
\code{\link{discover}}.}

\item{single_ref}{a logical, FALSE by default. If TRUE, then only one
reference between each relation pair is kept when generating foreign key
references. If a pair has multiple references, the kept reference refers to
the earliest key for the child relation, as sorted by priority order.}

\item{ensure_lossless}{a logical, TRUE by default. If TRUE, and the
decomposition isn't lossless, an extra relation is added to make the
decomposition lossless.}

\item{reduce_attributes}{a logical, TRUE by default. If TRUE,
\code{dependencies} are checked for determinant attributes that are made
redundant by the other dependencies. This is redundant if
\code{dependencies} is output from \code{discover}, since there will be no
such redundant attributes.}

\item{remove_avoidable}{a logical, indicating whether to remove avoidable
attributes in relations. If so, then an attribute are removed from
relations if the keys can be changed such that it is not needed to preserve
the given functional dependencies.}

\item{constants_name}{a scalar character, giving the name for any relation
created to store constant attributes. If this is the same as a generated
relation name, it will be changed, with a warning, to ensure that all
relations have a unique name.}

\item{progress}{a logical, for whether to display progress to the user during
dependency search in \code{\link{discover}}.}

\item{progress_file}{a scalar character or a connection. If \code{progress}
is non-zero, determines where the progress is written to, in the same way
as the \code{file} argument for \code{\link[base]{cat}}.}
}
\value{
A \code{\link{database_schema}} object, containing the synthesis
relation schemas and the created foreign key references.
}
\description{
Creates a database schema from given functional dependencies, satisfying at
least third normal form, using Bernstein's synthesis.
}
\details{
This is a wrapper function for applying \code{\link{synthesise}} and
\code{\link{autoref}}, in order. For creating relation schemas and foreign
key references separately, use these functions directly. See both functions
for examples.

For details on the synthesis algorithm used, see \code{\link{synthesise}}.
}
