# Find index of maximum, breaking ties at random and ignoring NAs.
# @title Index of maximum with random ties
# @param x Input vector.
# @return Index of the maximum value.
# @author Marvin N. Wright
which.max.random <- function(x) {
  if (all(is.na(x))) {
    return(NA)
  }
  which(rank(x, ties.method = "random", na.last = FALSE) == length(x))
}

# Find index of minimum, breaking ties at random and ignoring NAs.
# @title Index of minimum with random ties
# @param x Input vector.
# @return Index of the minimum value.
# @author Marvin N. Wright
which.min.random <- function(x) {
  if (all(is.na(x))) {
    return(NA)
  }
  which(rank(x, ties.method = "random", na.last = TRUE) == 1)
}