% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slice_sample.R
\name{slice_sample}
\alias{slice_sample}
\alias{slice_sample.log}
\alias{slice_sample.grouped_log}
\title{Sample function for logs}
\usage{
slice_sample(.data, ..., n, prop, by = NULL, weight_by = NULL, replace = FALSE)

\method{slice_sample}{log}(.data, ..., n, prop, weight_by = NULL, replace = FALSE)

\method{slice_sample}{grouped_log}(.data, ..., n, prop, weight_by = NULL, replace = FALSE)
}
\arguments{
\item{.data}{A data frame, data frame extension (e.g. a tibble), or a
lazy data frame (e.g. from dbplyr or dtplyr). See \emph{Methods}, below, for
more details.}

\item{...}{
  Arguments passed on to \code{\link[dplyr:slice]{dplyr::slice_sample}}
  \describe{
    \item{\code{n,prop}}{Provide either \code{n}, the number of rows, or \code{prop}, the
proportion of rows to select. If neither are supplied, \code{n = 1} will be
used. If \code{n} is greater than the number of rows in the group
(or \code{prop > 1}), the result will be silently truncated to the group size.
\code{prop} will be rounded towards zero to generate an integer number of
rows.

A negative value of \code{n} or \code{prop} will be subtracted from the group
size. For example, \code{n = -2} with a group of 5 rows will select 5 - 2 = 3
rows; \code{prop = -0.25} with 8 rows will select 8 * (1 - 0.25) = 6 rows.}
  }}

\item{n, prop}{Provide either \code{n}, the number of rows, or \code{prop}, the
proportion of rows to select. If neither are supplied, \code{n = 1} will be
used. If \code{n} is greater than the number of rows in the group
(or \code{prop > 1}), the result will be silently truncated to the group size.
\code{prop} will be rounded towards zero to generate an integer number of
rows.

A negative value of \code{n} or \code{prop} will be subtracted from the group
size. For example, \code{n = -2} with a group of 5 rows will select 5 - 2 = 3
rows; \code{prop = -0.25} with 8 rows will select 8 * (1 - 0.25) = 6 rows.}

\item{by}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> Optionally, a selection of columns to
group by for just this operation, functioning as an alternative to \code{\link[dplyr:group_by]{group_by()}}. For
details and examples, see \link[dplyr:dplyr_by]{?dplyr_by}.}

\item{weight_by}{<\code{\link[rlang:args_data_masking]{data-masking}}> Sampling
weights. This must evaluate to a vector of non-negative numbers the same
length as the input. Weights are automatically standardised to sum to 1.}

\item{replace}{Should sampling be performed with (\code{TRUE}) or without
(\code{FALSE}, the default) replacement.}
}
\description{
Sample function for logs
}
\section{Methods (by class)}{
\itemize{
\item \code{slice_sample(log)}: Sample \code{n} cases of a \code{\link{log}}.

\item \code{slice_sample(grouped_log)}: Sample \code{n} cases from a \code{\link{grouped_log}}.

}}
