% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ard_attributes.survey.design.R
\name{ard_attributes.survey.design}
\alias{ard_attributes.survey.design}
\title{ARD Attributes}
\usage{
\method{ard_attributes}{survey.design}(data, variables = everything(), label = NULL, ...)
}
\arguments{
\item{data}{(\code{survey.design})\cr
a design object often created with \code{\link[survey:svydesign]{survey::svydesign()}}.}

\item{variables}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
variables to include}

\item{label}{(named \code{list})\cr
named list of variable labels, e.g. \code{list(cyl = "No. Cylinders")}.
Default is \code{NULL}}

\item{...}{These dots are for future extensions and must be empty.}
}
\value{
an ARD data frame of class 'card'
}
\description{
Add variable attributes to an ARD data frame.
\itemize{
\item The \code{label} attribute will be added for all columns, and when no label
is specified and no label has been set for a column using the \verb{label=} argument,
the column name will be placed in the label statistic.
\item The \code{class} attribute will also be returned for all columns.
\item Any other attribute returned by \code{attributes()} will also be added, e.g. factor levels.
}
}
\examples{
\dontshow{if (do.call(asNamespace("cardx")$is_pkg_installed, list(pkg = "survey"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data(api, package = "survey")
dclus1 <- survey::svydesign(id = ~dnum, weights = ~pw, data = apiclus1, fpc = ~fpc)

ard_attributes(
  data = dclus1,
  variables = c(sname, dname),
  label = list(sname = "School Name", dname = "District Name")
)
\dontshow{\}) # examplesIf}
}
