% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmahalanobis.R
\name{cjaccard}
\alias{cjaccard}
\title{Calculate the Jaccard distance for each species.}
\usage{
cjaccard(
  dataset,
  formula,
  plot = TRUE,
  plot_title = "Jaccard Distance Between Groups"
)
}
\arguments{
\item{dataset}{A dataframe.}

\item{formula}{A factor which you want to calculate the Jaccard distances matrix.}

\item{plot}{Logical, if TRUE, a plot of Jaccard distances matrix is displayed.}

\item{plot_title}{The title to be used for the plot if plot is TRUE.}
}
\value{
A matrix containing Jaccard distances between each pair of groups and the plot.
}
\description{
This function takes a dataframe and a factor in input, and returns a matrix with the Jaccard distances about it.
}
\examples{
# Example with the iris dataset

cjaccard(iris, ~Species, plot = TRUE, plot_title = "Jaccard Distance Between Groups")

# Example with the mtcars dataset
cjaccard(mtcars, ~am, plot = TRUE, plot_title = "Jaccard Distance Between Groups")

}
