% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bind_defined_rows.R
\name{bind_defined_rows}
\alias{bind_defined_rows}
\title{Bind strictly defined rows}
\usage{
bind_defined_rows(x, y, ..., strict = FALSE)
}
\arguments{
\item{x}{A \code{dataset_df} object.}

\item{y}{A \code{dataset_df} object to bind to \code{x}.}

\item{...}{Optional dataset-level attributes such as \code{title} or
\code{creator} to override.}

\item{strict}{Logical. If \code{TRUE} (default), require full semantic
compatibility, including rowid.}
}
\value{
A new \code{dataset_df} object with rows from \code{x} and \code{y}, combined
semantically.
}
\description{
Add rows of dataset \code{y} to dataset \code{x}, validating all
semantic metadata. Metadata (labels, units, concept definitions,
namespaces) must match exactly. Additional dataset-level metadata such as
title and creator can be overridden using \code{...}.
}
\details{
This function combines two semantically enriched datasets created
with \code{dataset_df()}. All variable-level attributes — including labels,
units, concept definitions, and namespaces — must match. If \code{strict =
TRUE} (the default), the row identifier namespace (used in the \code{rowid}
column) must also match exactly.

If \code{strict = FALSE}, row identifiers from \code{y} may differ and will
be ignored; the output will inherit \code{x}'s row identifier scheme.
}
\examples{
A <- dataset_df(
  length = defined(c(10, 15),
    label = "Length",
    unit = "cm", namespace = "http://example.org"
  ),
  identifier = c(id = "http://example.org/dataset#"),
  dataset_bibentry = dublincore(
    title = "Dataset A",
    creator = person("Alice", "Smith")
  )
)

B <- dataset_df(
  length = defined(c(20, 25),
    label = "Length",
    unit = "cm", namespace = "http://example.org"
  ),
  identifier = c(id = "http://example.org/dataset#")
)

bind_defined_rows(A, B) # succeeds

C <- dataset_df(
  length = defined(c(30, 35),
    label = "Length",
    unit = "cm", namespace = "http://example.org"
  ),
  identifier = c(id = "http://another.org/dataset#")
)

\dontrun{
bind_defined_rows(A, C, strict = TRUE) # fails: mismatched rowid
}

bind_defined_rows(A, C, strict = FALSE) # succeeds: rowid inherited
}
