% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BoundingCovariateEffects.R
\name{get.extra.Estep.points}
\alias{get.extra.Estep.points}
\title{Get extra evaluation points for E-step}
\usage{
get.extra.Estep.points(dir, theta.hash, maxviol.hash, hyperparams)
}
\arguments{
\item{dir}{Search direction. \code{dir = 1} corresponds to looking for an
upper bound. \code{dir = -1} corresponds to looking for a lower bound.}

\item{theta.hash}{Tentative optimal value for theta, i.e., the largest or
smallest feasible value for theta (if dir = 1 or dir = -1, respectively). A
'feasible value' is one that satisfies all moment restrictions.}

\item{maxviol.hash}{Violation curve evaluated at  \code{theta.hash}.}

\item{hyperparams}{List of hyperparameters.}
}
\value{
Points to evaluate in E-step.
}
\description{
Function used to obtain extra theta values to be supplied to the
E-step in the next iteration (M_step.R). Note: this function should be
changed when implementing the sample space contractions (see comment made in
documentation of \code{M_step}).
}
