% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dock_view.R
\name{panel}
\alias{panel}
\title{Dock panel}
\usage{
panel(
  id,
  title,
  content,
  active = TRUE,
  remove = list(enable = FALSE, mode = "auto"),
  ...
)
}
\arguments{
\item{id}{Panel unique id.}

\item{title}{Panel title.}

\item{content}{Panel content. Can be a list of Shiny tags.}

\item{active}{Is active?}

\item{remove}{List with two fields: enable and mode. Enable is a boolean
and mode is one of \code{manual}, \code{auto} (default to auto). In auto mode,
dockview JS removes the panel when it is closed and all its content. If you
need more control over the panel removal, set it to manual so you can explicitly
call \code{remove_panel()} and perform other tasks. On the server side, a shiny input is available
\code{input[["<dock_ID>_panel-to-remove"]]} so you can create observers with custom logic.}

\item{...}{Other options passed to the API.
See \url{https://dockview.dev/docs/api/dockview/panelApi/}.
If you pass position, it must be a list with 2 fields:
\itemize{
\item referencePanel: reference panel id.
\item direction: one of \code{above}, \code{below}, \code{left}, \code{right} or \code{within}
(\code{above}, \code{below}, \code{left}, \code{right} put the panel in a new group,
while \code{within} puts the panel after its reference panel in the same group).
Position is relative to the reference panel target.
}}
}
\value{
A list representing a panel object to be consumed by
\link{dock_view}:
\itemize{
\item id: unique panel id (string).
\item title: panel title (string).
\item content: panel content (\code{shiny.tag.list} or single \code{shiny.tag}).
\item active: whether the panel is active or not (boolean).
\item ...: extra parameters to pass to the API.
}
}
\description{
Create a panel for use within a \code{\link[=dock_view]{dock_view()}} widget.
Panels are the main container components that can be docked, dragged,
resized, and arranged within the dockview interface.
}
