% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jointRecCompet.R
\name{jointRecCompet}
\alias{jointRecCompet}
\title{Competing Joint Frailty Model: A single type of recurrent event and two
terminal events.}
\usage{
jointRecCompet(formula,
         formula.terminalEvent = NULL,
         formula.terminalEvent2 = NULL,
         data,
         initialize = TRUE,
         recurrentAG = FALSE,
         maxit = 350,
         hazard = "Weibull",
         n.knots=7,
         kappa = rep(10, 3),
         crossVal=FALSE,
         constraint.frailty = "squared",
         GHpoints = 32,
         tolerance = rep(10^-3, 3),
         init.hazard = NULL,
         init.Sigma = 0.5,
         init.Alpha1 = 0.1,
         init.Alpha2 = -0.1,
         init.B = NULL)
}
\arguments{
\item{formula}{a formula object, with the response for the first recurrent
event on the left of a \eqn{\sim} operator, and the terms on the right.
The response must be in the format Surv(t0, t1, recurrentevent) for a calendar-time
specification where \code{t0} is the start time for an at-risk period for the recurrent event,
\code{t1} is the end time for an at-risk period for the recurrent event, and
\code{recurrentevent} is a numeric indicator for whether an event was observed (1)
or was censored (2).
In a gap-time setting, an object of the format Surv(t, recurrentevent) should be used instead.
Note that to not be confused with a left-truncation setting, when using a calendar-time specification 
argument \code{recurrentAG} should be set to \code{TRUE}.}

\item{formula.terminalEvent, }{a formula object,
empty on the left of a \eqn{\sim} operator,
and the terms on the right. Leave the formula at
the default value (NULL) for a model with no variables.}

\item{formula.terminalEvent2, }{a formula object,
empty on the left of a \eqn{\sim} operator,
and the terms on the right.Leave the formula at
the default value (NULL) for a model with no variables.}

\item{data}{a 'data.frame' with the variables used in 'formula',
'formula.terminalEvent', and 'formula.terminalEvent2'.}

\item{initialize}{Logical value to internally initialize regression coefficients and
baseline hazard functions parameters using simpler models from frailtypack.
When initialization is requested, the
program first fits two joint frailty models for the recurrent
events and each terminal event.
When FALSE, parameters are initialized via the arguments
init.hazard, init.Sigma, init.Alpha1, init.Alpha2, init.B.}

\item{recurrentAG}{Logical value. Is Andersen-Gill model fitted? 
If so indicates that recurrent event times with the counting 
process approach of Andersen and Gill is used. This formulation can be 
used for dealing with time-dependent covariates. The default is FALSE.}

\item{maxit}{maximum number of iterations for the Marquardt algorithm.
Default is 350.}

\item{hazard}{Type of hazard functions. Available options are \code{"Weibull"} 
for parametric Weibull function, \code{"Splines"} for semiparametric
hazard functions using equidistant intervals or \code{"Splines-per"} for
percentile intervals. Default is \code{"Weibull"}.}

\item{n.knots}{In the case of splines hazard functions, number of knots to be used 
in the splines basis. This number should be between 4 and 20. Default is 7.}

\item{kappa}{In the case of splines hazard functions, a vector of size 3 containing
the values of the smoothing parameters to be used for each baseline hazard function. 
Default value is 10 for each function.}

\item{crossVal}{In the case of splines hazard functions, indicates how 
the smoothing parameters are chosen. If set to "TRUE" then those parameters
are chosen automatically using cross-validation on reduced models for each 
baseline hazard function. If set to "FALSE" then the parameters are those provided 
by the argument \code{kappa}. If set to "TRUE" then the argument \code{kappa} is 
ignored. Default is "TRUE".}

\item{constraint.frailty}{Type of positivity constraint used for the variance of
of the random effect in the likelihood. Possible values are 'squared' or 'exponential'. 
Default is 'squared'. See Details.}

\item{GHpoints}{Integer. Number of nodes for Gauss-Hermite integration
to marginalize random effects/frailties. Default is 32.}

\item{tolerance}{Numeric, length 3. Optimizer's tolerance for (1) successive change
in parameter values, (2) log likelihood, and (3) score, respectively.}

\item{init.hazard}{Numeric. Initialization values for hazard parameters.
If a weibull model is used, the order is:
shapeR, scaleR, shapeTerminal1, scaleTerminal1, shapeTerminal2, scaleTerminal2.}

\item{init.Sigma}{Numeric,. Initialization value for the standard deviation of the
normally-distributed random effects.}

\item{init.Alpha1}{Numeric. Initialization value for the parameter alpha that
links the hazard function of the recurrent event to the first terminal event.}

\item{init.Alpha2}{Numeric. Initialization value for the parameter alpha that
links the hazard function of the recurrent event to the second terminal event.}

\item{init.B}{Numeric vector of the same length and order 
as the three covariate vectors for the recurrent, terminal1,
and terminal2 events (in that order).}
}
\value{
Parameters estimates of a competing joint frailty model, more
generally a 'jointRecCompet' object. Methods defined for 'jointRecCompet' objects
are provided for print, plot and summary. The following components are
included in a 'jointRecCompet' object.

\item{summary.table}{A table describing the estimate, standard error,
confidence interval, and pvalues for each of the parameters in the model.}

\item{controls}{A vector of named control parameters}

\item{k0}{For splines baseline hazard functions, vector of penalization terms.}

\item{noVarEvent}{A vector containing for each event type if there is no covariate used
in the model.}

\item{np}{Total number of parameters}

\item{b}{Vector containing the estimated coefficients of the model before any positivity constraint.
The values are in order: the coefficients associated with the baseline hazard functions 
(either the splines or the shape and scale parameters for Weibull hazard), 
the random effect variance, the coefficients of the frailty (\eqn{\alpha_1} and \eqn{\alpha_2}) 
and the regression coefficients.}

\item{H_hessOut}{Covariance matrix of the estimated parameters}

\item{HIHOut}{Covariance matrix of the estimated parameters for the penalized likelihood
in the case of Splines baseline hazard functions.}

\item{LCV}{The approximated likelihood cross-validation criterion in the spline case}

\item{critCV}{Convergence criteria}

\item{x1}{Vector of times for which the hazard function of
the recurrent event is estimated.
By default seq(0,max(time),length=99),
where time is the vector of survival times.}

\item{lam1}{Matrix of hazard estimates and confidence bands for the recurrent
event.}

\item{xSu1}{Vector of times for the survival function of
the recurrent event.}

\item{surv1}{Matrix of baseline survival
estimates and confidence bands for recurrent event.}

\item{x2}{Vector of times for the first terminal event (see x1 value).}

\item{lam2}{Matrix of hazard estimates and confidence bands for the
first terminal event.}

\item{xSu2}{Vector of times for the survival function of the first terminal event.}

\item{surv2}{Vector of the survival function of the first terminal event evaluated at xSu2.}

\item{x3}{Vector of times for the second terminal event (see x1 value).}

\item{lam3}{Matrix of hazard estimates and confidence bands for the
second terminal event.}

\item{xSu3}{Vector of times for the survival function of the second terminal event.}

\item{surv3}{Vector of the survival function of the second terminal event evaluated at xSu3.}

\item{ni}{Number of iterations needed to converge.}

\item{constraintfrailty}{Positivity constraint used for the variance of the random effect} 

\item{ziOut1}{In the spline case, vector of knots used in the spline basis for the recurrent event}

\item{ziOutdc}{In the spline case, vector of knots used in the spline basis for the terminal events}

\item{ghnodes}{Nodes used for the Gauss-Hermite quadrature.}

\item{ghweights}{Weights used for the Gauss-Hermite quadrature.}

\item{tolerance}{Numeric, length 3. Optimizer's tolerance for (1) successive change
in parameter values, (2) log likelihood, and (3) score, respectively.}

\item{call}{Call of the function.}

\item{loglikPenal}{Estimated penalized log-likelihood in the spline case}

\item{logLik}{Estimated log-likelihood in the Weibull case}

\item{AIC}{For the Weibull case, Akaike Information criterion}

\item{n}{Total number of subjects}

\item{nevts}{Number of events for each event type.}
}
\description{
Fit a joint competing frailty model for a single recurrent event
and two terminal events defined as,

\deqn{\text {Recurrent event:} \quad r_{i j}\left(t \mid w_i, 
\boldsymbol{X}_{r, i j}\right)=r_0(t) \exp \left(\boldsymbol{X}_{r, i j} \boldsymbol{\beta}_r+w_i\right)}
\deqn{\text{First terminal event:} \quad \lambda_{1, i}\left(t \mid w_i, 
\boldsymbol{X}_{1 i}\right)=\lambda_{1, 0}(t) \exp \left(\boldsymbol{X}_{1, i} \boldsymbol{\beta}_1+\alpha_1 w_i\right)}
\deqn{\text{Second terminal event:} \quad \lambda_{2, i}\left(t \mid w_i, 
\boldsymbol{X}_{2, i}\right)=\lambda_{2, 0}(t) \exp \left(\boldsymbol{X}_{2, i} \boldsymbol{\beta}_2+\alpha_2 w_i\right).}

where \eqn{\omega_i \sim \mathcal{N}(0,\theta)} is the frailty term and \eqn{\boldsymbol{X}_{r, i j},\boldsymbol{X}_{1, i}} and
\eqn{\boldsymbol{X}_{2, i}} are vectors of baseline covariates (possibly the same). The parameters \eqn{\alpha_1} and \eqn{\alpha_2}
are power parameters.
}
\details{
Right-censored data are allowed.
Left-truncated data and stratified analysis are not possible. 
Prediction options are not yet available. 
The \code{constraint.frailty} argument defines the positivity constraint 
used for the frailty variance in the likelihood. By default it uses the square 
so that the absolute value of the parameter is the standard deviation of the frailty
(i.e \eqn{\theta^2 = \beta^2}). 
The other parametrization uses the square of the exponential for the variance
so that the parameter is the logarithm of the standard deviation (\eqn{\theta^2 = (\exp{\beta})^2}).
For others parameters in the model needing a positivity constraint (parameters related to the
baseline hazard functions), the parametrization used is the exponential squared.
}
\examples{
\donttest{
set.seed(1)
data=simulatejointRecCompet(n=500,
		par0=c(shapeR = 1.5, scaleR = 10, 
		shapeM = 1.75, scaleM = 16, shapeD = 1.75, scaleD = 16, sigma = 0.5, 
		alphaM = 1, alphaD = 1, betaR = -0.5, betaM = -0.5, betaD = 0) )
mod <-jointRecCompet(formula = Surv(tstart, tstop, event)~cluster(id)+treatment+
                    terminal(terminal1)+terminal2(terminal2),
                    formula.terminalEvent = ~treatment,
                    formula.terminalEvent2 = ~treatment,
                    data = data,
                    recurrentAG = TRUE,
                    initialize = TRUE,
					   n.knots=7,
					   crossVal=TRUE,
                    hazard = "Splines",
                    maxit = 350)

#This example uses an extract of 500 patients of the REDUCE trial
data(reduce)
mod_reduce <-jointRecCompet(formula = Surv(t.start,t.stop, del)~cluster(id)+
					   treatment+terminal(death)+terminal2(discharge),
                    formula.terminalEvent = ~treatment,
                    formula.terminalEvent2 = ~treatment,
                    data = reduce,
                    initialize = TRUE,
                    recurrentAG = TRUE,
                    hazard = "Weibull",
                    constraint.frailty = "exponential",
                    maxit = 350)
print(mod_reduce)
}
}
\seealso{
\code{\link{terminal}}
}
