% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_gridplothaptable2.R
\name{plotHapTable2}
\alias{plotHapTable2}
\title{plotHapTable2}
\usage{
plotHapTable2(
  hapSummary,
  show_indel_size = 1,
  replaceMultiAllele = TRUE,
  angle = 0,
  show_INFO = FALSE,
  INFO_split = c(";", ",", "\\\\|"),
  INFO_tag = "ANN",
  geneID = NA,
  tag_field = -1,
  title = "",
  gff = NULL,
  show_chr_name = TRUE,
  Chr = NULL,
  start = NULL,
  end = NULL,
  model_rect_col = "black",
  model_rect_fill = "grey80",
  model_line_col = "black",
  model_anno_txt = NULL,
  model_anno_col = "black",
  model_anno_cex = 1,
  table_txt_col = "black",
  table_txt_cex = 1,
  model_anno_pos = c(-1, -1),
  model_anno_adj = c(0, 1),
  gene_model_height = 0.2,
  space_height = 0.1,
  table_height = NULL,
  CDS_height = 0.3,
  link_line_type = 3,
  headrows = 1,
  equal_col_width = FALSE,
  head_anno = 1,
  col_annots = 0,
  row_labels = 1,
  row_annots = 1,
  table_line_col = "white",
  annot_for_each_transcrips = TRUE,
  labels_fill = "white",
  annot_fill = "grey90",
  head_fill = NULL,
  cell_fill = NULL,
  style = gpar(fontfamily = "sans", fontface = 1, cex = 0.7),
  footbar = "",
  ...
)
}
\arguments{
\item{hapSummary}{the hapSummary or hapResult object}

\item{show_indel_size}{the Indel length longer will be replaced by "i1,i2,i3,..."}

\item{replaceMultiAllele}{replace multi-allele title by 'T1,T2,...' or not}

\item{angle}{the angle of number positions}

\item{show_INFO}{show annotation field or not, default as \code{FALSE}}

\item{INFO_split, INFO_tag, geneID, tag_field}{used to set annotation in haplotype table.
And the geneID was used to fileter annotation in INFO field.}

\item{title}{title of plot}

\item{gff}{gff or bed annotation}

\item{show_chr_name}{show chromosome name at left-top cell or not}

\item{Chr, start, end}{which range should be plotted in gene model}

\item{model_rect_col, model_rect_fill, model_line_col}{a string specified the color for line/rectangle in gene model}

\item{table_txt_col, table_txt_cex}{controls the color and size of texts in genotype table}

\item{model_anno_pos, model_anno_adj, model_anno_cex, model_anno_col, model_anno_txt}{the position (x,y), just (hjust, vjust), color, size and content of annotation text in gene model}

\item{gene_model_height, table_height, space_height}{the plotting range height of gene model, table and spacer}

\item{CDS_height}{a numeric vector specified the height of CDS, and the height of utr is half of that,
only useful when gff is provided,}

\item{link_line_type}{the type of link lines for mutations in gene model and genotype table}

\item{equal_col_width}{a bool or numeric vector specified whether column with should be equal}

\item{col_annots, head_anno, headrows, row_annots, row_labels}{the column or row number of annotation or labels or heads}

\item{table_line_col}{the line color in genotype table}

\item{annot_for_each_transcrips}{mark the strand and trancripts name for each gene modle}

\item{annot_fill, head_fill, labels_fill}{the fill color of annotation, head and label row or columns}

\item{cell_fill}{a color vector or function or named vector specified cell fill color}

\item{style}{see help(gpar)}

\item{footbar}{the foot notes}

\item{...}{param not used}
}
\description{
plot the hapResult in table like style using grid system.
This function is under development and may not stable.
Some parameters may deleted or renamed in future.
}
\examples{
#
data(geneHapR_test)
plotHapTable2(hapResult)
plotHapTable2(hapResult, gff = gff)
}
