% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GMVARconstruction.R
\name{gmvar_to_sgmvar}
\alias{gmvar_to_sgmvar}
\title{Switch from two-regime reduced form GMVAR model to a structural GMVAR model.}
\usage{
gmvar_to_sgmvar(gmvar, calc_std_errors = TRUE)
}
\arguments{
\item{gmvar}{an object of class \code{'gmvar'} created with \code{fitGMVAR} or \code{GMVAR}.}

\item{calc_std_errors}{should approximate standard errors be calculated?}
}
\value{
Returns an object of class \code{'gmvar'} defining a structural GMVAR model based on a
  two-regime reduced form GMVAR model with the main diagonal of the B-matrix normalized to be
  positive.
}
\description{
\code{gmvar_to_sgmvar} constructs SGMVAR model based on a reduced form GMVAR model.
}
\details{
The switch is made by simultaneously diagonalizing the two error term covariance matrices
  with a well known matrix decomposition (Muirhead, 1982, Theorem A9.9) and then normalizing the
  diagonal of the matrix W positive (which implies positive diagonal of the B-matrix). Models with
  more that two regimes are not supported because the matrix decomposition does not generally
  exists for more than two covariance matrices. If the model has only one regime (= regular SVAR model),
  a symmetric and pos. def. square root matrix of the error term covariance matrix is used.

  The columns of \eqn{W} as well as the lambda parameters can be re-ordered (without changing the implied
  reduced form model) afterwards with the function \code{reorder_W_columns}. Also all signs in any column
  of \eqn{W} can be swapped (without changing the implied reduced form model) afterwards with the function
  \code{swap_W_signs}. These two functions work with models containing any number of regimes.
}
\examples{
\donttest{
# Reduced form GMVAR(1,2) model
params12 <- c(0.55, 0.112, 0.344, 0.055, -0.009, 0.718, 0.319,
 0.005, 0.03, 0.619, 0.173, 0.255, 0.017, -0.136, 0.858, 1.185,
 -0.012, 0.136, 0.674)
mod12 <- GMVAR(gdpdef, p=1, M=2, params=params12)

# Form a structural model based on the reduced form model:
mod12s <- gmvar_to_sgmvar(mod12)
mod12s
}
}
\references{
\itemize{
   \item Muirhead R.J. 1982. Aspects of Multivariate Statistical Theory, \emph{Wiley}.
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2016. Gaussian mixture vector autoregression.
         \emph{Journal of Econometrics}, \strong{192}, 485-498.
   \item Virolainen S. 2020. Structural Gaussian mixture vector autoregressive model. Unpublished working
     paper, available as arXiv:2007.04713.
 }
}
\seealso{
\code{\link{fitGMVAR}}, \code{\link{GMVAR}}, \code{\link{GIRF}}, \code{\link{reorder_W_columns}},
 \code{\link{swap_W_signs}}
}
