% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/censored.R
\name{beta_censored}
\alias{beta_censored}
\title{Beta Censored Distribution}
\usage{
beta_censored(
  alpha,
  beta,
  is_censored,
  censor = "right",
  lower = NULL,
  upper = NULL,
  dim = length(is_censored)
)
}
\arguments{
\item{alpha}{Shape parameter for successes.}

\item{beta}{Shape parameter for failures.}

\item{is_censored}{Logical vector indicating whether each observation is censored.}

\item{censor}{Type of censoring: one of 'right', 'left', 'interval'.}

\item{lower}{Lower bound for interval censoring (optional).}

\item{upper}{Upper bound for interval censoring (optional).}

\item{dim}{Dimension of the data (optional, defaults to length of \code{alpha}).}
}
\value{
A greta censored beta distribution node.
}
\description{
Creates a censored beta distribution for use with greta.
}
