% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/censored.R
\name{lognormal_censored}
\alias{lognormal_censored}
\title{Log-Normal Censored Distribution}
\usage{
lognormal_censored(
  meanlog,
  sdlog,
  is_censored,
  censor = "right",
  lower = NULL,
  upper = NULL,
  dim = length(is_censored)
)
}
\arguments{
\item{meanlog}{Mean of the log-transformed normal distribution.}

\item{sdlog}{Standard deviation of the log-transformed normal distribution.}

\item{is_censored}{Logical vector indicating whether each observation is censored.}

\item{censor}{Type of censoring: one of 'right', 'left', 'interval'.}

\item{lower}{Lower bound for interval censoring (optional).}

\item{upper}{Upper bound for interval censoring (optional).}

\item{dim}{Dimension of the data (optional, defaults to length of \code{meanlog}).}
}
\value{
A greta censored log-normal distribution node.
}
\description{
Creates a censored log-normal distribution for use with greta.
}
