% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opts.R
\name{opt_stylize}
\alias{opt_stylize}
\title{Stylize your table with a colorful look}
\usage{
opt_stylize(data, style = 1, color = "blue", add_row_striping = TRUE)
}
\arguments{
\item{data}{\emph{The gt table data object}

\verb{obj:<gt_tbl>} // \strong{required}

This is the \strong{gt} table object that is commonly created through use of the
\code{\link[=gt]{gt()}} function.}

\item{style}{\emph{Table style}

\verb{scalar<numeric|integer>(1>=val>=6)} // \emph{default:} \code{1}

Six numbered styles are available. Simply provide a number from \code{1} (the
default) to \code{6} to choose a distinct look.}

\item{color}{\emph{Color variation}

\verb{scalar<character>} // \emph{default:} \code{"blue"}

There are six color variations: \code{"blue"}, \code{"cyan"}, \code{"pink"}, \code{"green"},
\code{"red"}, and \code{"gray"}.}

\item{add_row_striping}{\emph{Allow row striping}

\verb{scalar<logical>} // \emph{default:} \code{TRUE}

An option to enable row striping in the table body for the \code{style} chosen.}
}
\value{
an object of class \code{gt_tbl}.
}
\description{
With \code{opt_stylize()} you can quickly style your \strong{gt} table with a carefully
curated set of background colors, line colors, and line styles. There are six
styles to choose from and they largely vary in the extent of coloring applied
to different table locations. Some have table borders applied, some apply
darker colors to the table stub and summary sections, and, some even have
vertical lines. In addition to choosing a \code{style} preset, there are six
\code{color} variations that each use a range of five color tints. Each of the
color tints have been fine-tuned to maximize the contrast between text and
its background. There are 36 combinations of \code{style} and \code{color} to choose
from.
}
\section{Examples}{


Use \code{exibble} to create a \strong{gt} table with a number of table parts added.
Then, use \code{opt_stylize()} to give the table some additional style
(using the \code{"cyan"} color variation and style number \code{6}).

\if{html}{\out{<div class="sourceCode r">}}\preformatted{exibble |>
  gt(rowname_col = "row", groupname_col = "group") |>
  summary_rows(
    groups = "grp_a",
    columns = c(num, currency),
    fns = c("min", "max")
  ) |>
  grand_summary_rows(
    columns = currency,
    fns = total ~ sum(., na.rm = TRUE)
  ) |>
  tab_source_note(source_note = "This is a source note.") |>
  tab_footnote(
    footnote = "This is a footnote.",
    locations = cells_body(columns = 1, rows = 1)
  ) |>
  tab_header(
    title = "The title of the table",
    subtitle = "The table's subtitle"
  ) |>
  opt_stylize(style = 6, color = "cyan")
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_opt_stylize_1.png" alt="This image of a table was generated from the first code example in the `opt_stylize()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

10-1
}

\section{Function Introduced}{

\code{v0.7.0} (Aug 25, 2022)
}

\seealso{
Other table option functions: 
\code{\link{opt_align_table_header}()},
\code{\link{opt_all_caps}()},
\code{\link{opt_css}()},
\code{\link{opt_footnote_marks}()},
\code{\link{opt_footnote_spec}()},
\code{\link{opt_horizontal_padding}()},
\code{\link{opt_interactive}()},
\code{\link{opt_row_striping}()},
\code{\link{opt_table_font}()},
\code{\link{opt_table_lines}()},
\code{\link{opt_table_outline}()},
\code{\link{opt_vertical_padding}()}
}
\concept{table option functions}
