/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
#ifndef H5PLextern_H
#define H5PLextern_H
#include "hdf5.h"
#if defined(_MSC_VER)
#define H5PLUGIN_DLL __declspec(dllexport)
#elif (__GNUC__ >= 4)
#define H5PLUGIN_DLL __attribute__((visibility("default")))
#else
#define H5PLUGIN_DLL
#endif
#ifdef __cplusplus
extern "C" {
#endif
H5PLUGIN_DLL H5PL_type_t H5PLget_plugin_type(void);
H5PLUGIN_DLL const void *H5PLget_plugin_info(void);
#ifdef __cplusplus
}
#endif
#endif
