% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pathway_lasso.R
\name{mediate_plasso}
\alias{mediate_plasso}
\title{Pathway LASSO for Mediation Analysis with High-Dimensional Mediators}
\source{
\url{https://github.com/zhaoyi1026/PathwayLasso}
}
\usage{
mediate_plasso(
  A,
  M,
  Y,
  lambdas = NULL,
  select_lambda = FALSE,
  vss_rep = 5,
  vss_cutoff = 0.1,
  omega_ratio = 1,
  phi = 2,
  maxit = 5000,
  tol = 1e-06
)
}
\arguments{
\item{A}{numeric vector containing exposure variable.}

\item{M}{numeric matrix of high-dimensional mediators.}

\item{Y}{numeric vector containing continuous outcome variable.}

\item{lambdas}{numeric vector of tuning parameters \code{lambda} for
which model is fitted. Default is a vector of length 50 ranging from 10^-5
to 10^4, with more density in the lower range.}

\item{select_lambda}{logical flag indicating whether to conduct a tuning
parameter selection using the Variable Selection Stability Criterion
described by Sun et al. (2013). Default is \code{FALSE}.}

\item{vss_rep}{if \code{select_lambda} is \code{TRUE}, number of VSSC
replications.}

\item{vss_cutoff}{if \code{select_lambda} is \code{TRUE}, cutoff used for
VSSC. Default is 0.1.}

\item{omega_ratio}{ratio of the \code{omega} parameter to \code{lambda}
parameter in the likelihood penalty. Default is 1.}

\item{phi}{value of the \code{phi} parameter in the likelihood penalty.
Default is 2. Cannot be less than 1/2.}

\item{maxit}{the maximum number of iterations. Default is 5000.}

\item{tol}{convergence tolerance. Default is 10^-6.}
}
\value{
A list containing:
\itemize{
\item \code{lambdas}: the \code{lambda}s attempted in the same order as the objects in \code{all_fits}.
\item \code{all_fits}: a list containing, for each \code{lambda}, a \code{data.frame} of the estimated mediation effects.
\item \code{chosen_lambda}: if \code{select_lambda} is \code{TRUE}, the \code{lambda} chosen by VSSC.
\item \code{chosen_fit}: if \code{select_lambda} is \code{TRUE}, the fit corresponding to the chosen \code{lambda}.
\item \code{vss}: if \code{select_lambda} is\code{TRUE}, a \code{data.frame} containing the variable selection stabilities.
}
}
\description{
\code{mediate_plasso} fits a high-dimensional mediation model
with the penalized likelihood described by Zhao and Luo (2022), estimating the
mediation contributions of each site.
}
\details{
Pathway LASSO fits a high-dimensional mediation model with a likelihood
that directly penalizes the mediator-outcome effects, exposure-mediator
effects, and mediation contributions (i.e., the mediation "pathways").
The shrinkage of the model is determined by three parameters--\code{phi},
\code{omega}, and \code{lambda}--with higher values tending to result in more
sparsity. Mediation results are returned for every unique value in the
inputted \code{lambdas} argument, in increasing order, excluding potentially
any for which the estimation was unsuccessful. For details on the exact
likelihood, see the first reference.

When implementing multiple lambdas (i.e., using either the default argument
to \code{lambdas} or specifying one's own vector), there is an option to
perform a tuning parameter selection using the Variable Selection Stability
Criterion proposed by Sun et al. (2013), which chooses the parameter for
which the variable selection is most stable in repeated data-splitting.
However, implementing this can be computationally costly, especially with a
long list of tuning parameters, since it involves re-fitting pathway LASSO
many times.
}
\examples{
A <- med_dat$A
M <- med_dat$M[,1:8]
Y <- med_dat$Y
# fit pathway LASSO for two tuning parameters and retrieve their fits
out <- mediate_plasso(A, M, Y, lambdas = c(10^-3, 10^-2), tol = 1e-4)
head(out$all_fits$lambda1)
head(out$all_fits$lambda2)


}
\references{
Zhao, Y. & Luo, X. Pathway LASSO: pathway estimation and
selection with high-dimensional mediators. Stat. Interface 15, 39-50 (2022).

Sun, W., Wang, J. & Fang, Y. Consistent selection of tuning parameters via
variable selection stability. J. Mach. Learn. Res. 14, 3419-3440 (2013).
}
