% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbmi.R
\name{make_rbmi_cluster}
\alias{make_rbmi_cluster}
\title{Create a \code{rbmi} ready cluster}
\usage{
make_rbmi_cluster(cluster_or_cores = 1, objects = NULL, packages = NULL)
}
\arguments{
\item{cluster_or_cores}{Number of parallel processes to use or an existing cluster to make use of}

\item{objects}{a named list of objects to export into the sub-processes}

\item{packages}{a character vector of libraries to load in the sub-processes

This function is a wrapper around \code{parallel::makePSOCKcluster()} but takes
care of configuring \code{rbmi} to be used in the sub-processes as well as loading
user defined objects and libraries and setting the seed for reproducibility.}
}
\value{
If \code{cluster_or_cores} is \code{1} this function will return \code{NULL}. If \code{cluster_or_cores}
is a number greater than \code{1}, a cluster with \code{cluster_or_cores}  cores is returned.

If \code{cluster_or_cores} is a cluster created via \code{parallel::makeCluster()} then this function
returns it after inserting the relevant \code{rbmi} objects into the existing cluster.
}
\description{
Create a \code{rbmi} ready cluster
}
\examples{
\dontrun{
make_rbmi_cluster(5)
closeAllConnections()

VALUE <- 5
myfun <- function(x) {
  x + day(VALUE)
}
make_rbmi_cluster(5, list(VALUE = VALUE, myfun = myfun), c("lubridate"))
closeAllConnections()

cl <- parallel::makeCluster(5)
make_rbmi_cluster(cl)
closeAllConnections()
}
}
