% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_c_pd.R
\name{lsm_c_pd}
\alias{lsm_c_pd}
\title{PD (class level)}
\usage{
lsm_c_pd(landscape, directions = 8)
}
\arguments{
\item{landscape}{A categorical raster object: SpatRaster; Raster* Layer, Stack, Brick; stars or a list of SpatRasters.}

\item{directions}{The number of directions in which patches should be
connected: 4 (rook's case) or 8 (queen's case).}
}
\value{
tibble
}
\description{
Patch density (Aggregation metric)
}
\details{
\deqn{PD = \frac{n_{i}} {A} * 10000 * 100}
where \eqn{n_{i}} is the number of patches and \eqn{A} is the total landscape
area in square meters.

PD is an 'Aggregation metric'. It describes the fragmentation of a class, however, does not
necessarily contain information about the configuration or composition of the class. In
contrast to \code{\link{lsm_c_np}} it is standardized to the area and comparisons among
landscapes with different total area are possible.

\subsection{Units}{Number per 100 hectares}
\subsection{Ranges}{0 < PD <= 1e+06}
\subsection{Behaviour}{Increases as the landscape gets more patchy. Reaches its maximum
if every cell is a different patch.}
}
\examples{
landscape <- terra::rast(landscapemetrics::landscape)
lsm_c_pd(landscape)

}
\references{
McGarigal K., SA Cushman, and E Ene. 2023. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical Maps. Computer software program produced by the authors;
available at the following web site: https://www.fragstats.org
}
\seealso{
\code{\link{lsm_c_np}},
\code{\link{lsm_l_ta}}, \cr
\code{\link{lsm_l_pd}}
}
