% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_c_shape_mn.R
\name{lsm_c_shape_mn}
\alias{lsm_c_shape_mn}
\title{SHAPE_MN (class level)}
\usage{
lsm_c_shape_mn(landscape, directions = 8)
}
\arguments{
\item{landscape}{A categorical raster object: SpatRaster; Raster* Layer, Stack, Brick; stars or a list of SpatRasters.}

\item{directions}{The number of directions in which patches should be
connected: 4 (rook's case) or 8 (queen's case).}
}
\value{
tibble
}
\description{
Mean shape index (Shape metric)
}
\details{
\deqn{SHAPE_{MN} = mean(SHAPE[patch_{ij}])}
where \eqn{SHAPE[patch_{ij}]} is the shape index of each patch.

SHAPE_MN is a 'Shape metric'. Each class is summarised as the mean
of each patch belonging to class i. SHAPE describes the ratio between the actual perimeter of
the patch and the square root of patch area.

\subsection{Units}{None}
\subsection{Range}{SHAPE_SD >= 1}
\subsection{Behaviour}{Equals SHAPE_MN = 1 if all patches are squares.
Increases, without limit, as the shapes of patches become more complex.}
}
\examples{
landscape <- terra::rast(landscapemetrics::landscape)
lsm_c_shape_mn(landscape)

}
\references{
McGarigal K., SA Cushman, and E Ene. 2023. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical Maps. Computer software program produced by the authors;
available at the following web site: https://www.fragstats.org

Patton, D. R. 1975. A diversity index for quantifying habitat "edge".
Wildl. Soc.Bull. 3:171-173.
}
\seealso{
\code{\link{lsm_p_shape}},
\code{\link{mean}}, \cr
\code{\link{lsm_c_shape_sd}},
\code{\link{lsm_c_shape_cv}}, \cr
\code{\link{lsm_l_shape_mn}},
\code{\link{lsm_l_shape_sd}},
\code{\link{lsm_l_shape_cv}}
}
