% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tailindex.R
\name{PickandsXU}
\alias{PickandsXU}
\title{Extreme U-statistic Pickands estimator}
\usage{
PickandsXU(xdat, m)
}
\arguments{
\item{xdat}{vector of observations of length \eqn{n}}

\item{m}{number of largest order statistics \eqn{3 \leq m \leq n}. Choosing \eqn{m = n} amounts to using only the three largest observations in the sample.}
}
\description{
Given a random sample of exceedances, the estimator
returns an estimator of the shape parameter or extreme
value index using a kernel of order 3, based on
\code{m} largest exceedances of \code{xdat}.
}
\details{
The calculations are based on the recursions provided in Lemma 4.3 of Oorschot et al.
}
\examples{
samp <- rgp(n = 1000, shape = 0.2)
PickandsXU(samp, m = 3)
}
\references{
Oorschot, J, J. Segers and C. Zhou (2023), Tail inference using extreme U-statistics,  Electron. J. Statist. 17(1): 1113-1159. \doi{10.1214/23-EJS2129}
}
