% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profile.R
\name{confint.eprof}
\alias{confint.eprof}
\title{Confidence intervals for profile likelihood objects}
\usage{
\method{confint}{eprof}(
  object,
  parm,
  level = 0.95,
  prob = c((1 - level)/2, 1 - (1 - level)/2),
  print = FALSE,
  method = c("cobs", "smooth.spline"),
  ...
)
}
\arguments{
\item{object}{an object of class \code{eprof}, normally the output of \link{gpd.pll} or \link{gev.pll}.}

\item{parm}{a specification of which parameters are to be given confidence intervals,
either a vector of numbers or a vector of names. If missing, all parameters are considered.}

\item{level}{confidence level, with default value of 0.95}

\item{prob}{percentiles, with default giving symmetric 95\% confidence intervals}

\item{print}{should a summary be printed. Default to \code{FALSE}.}

\item{method}{string for the method, either \code{cobs} (constrained robust B-spline from eponym package) or \code{smooth.spline}}

\item{...}{additional arguments passed to functions. Providing a logical \code{warn=FALSE} turns off warning messages when the lower or upper confidence interval for \code{psi} are extrapolated beyond the provided calculations.}
}
\value{
returns a 2 by 3 matrix containing point estimates, lower and upper confidence intervals based on the likelihood root and modified version thereof
}
\description{
Computes confidence intervals for the parameter psi for profile likelihood objects.
This function uses spline interpolation to derive \code{level} confidence intervals
}
