% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update.R
\name{docdb_update}
\alias{docdb_update}
\title{Update documents}
\usage{
docdb_update(src, key, value, query, ...)
}
\arguments{
\item{src}{Source object, result of call to any of functions
\code{\link[=src_mongo]{src_mongo()}}, \code{\link[=src_sqlite]{src_sqlite()}}, \code{\link[=src_elastic]{src_elastic()}}, \code{\link[=src_couchdb]{src_couchdb()}}
\code{\link[=src_duckdb]{src_duckdb()}} or \code{\link[=src_postgres]{src_postgres()}}}

\item{key}{(character) The name of the container in the
database backend (corresponds to \code{collection} for MongoDB,
\code{dbname} for CouchDB, \code{index} for Elasticsearch, and to
a table name for DuckDB, SQLite and PostgreSQL)}

\item{value}{The data to be created in the database:
a single data.frame, a JSON string, a list, or a
file name or URL that points to NDJSON documents}

\item{query}{(character) A JSON query string, see examples.
Can use comparisons / tests (\verb{$lt}, \verb{$lte}, \verb{$gt}, \verb{$gte},
\verb{$ne}, \verb{$in}, \verb{$regex}), with logic operators (\verb{$and},
\verb{$or}, \code{(}, \verb{)}), including nested queries, see examples.
Specify as \code{'{}'} if \code{value} includes \verb{_id}'s.}

\item{...}{Passed on to functions \code{\link[elastic:docs_bulk_update]{elastic::docs_bulk_update()}},
and \code{\link[mongolite:mongo]{mongolite::mongo()}}$update().}
}
\value{
(integer) Number of successfully updated documents
}
\description{
Documents are updated by patching their JSON with
\code{value}. Documents are identified by a \code{query}
or by \verb{_id}'s in \code{value}, where the latter takes
precedence. \code{value} can have multiple documents (with
\verb{_id}'s), which then are iteratively updated.
}
\details{
Uses native functions in MongoDB (\code{\link[mongolite:mongo]{mongolite::mongo()}}$update()),
SQLite (\code{jsonb_update()}), DuckDB (\code{jsonb_merge_patch()}),
Elasticsearch (\code{elastic::docs_bulk_update()});
a \code{plpgsql} function added when calling \code{src_postgres()},
and a \code{\link[jqr:jqr]{jqr::jqr()}} programme for CouchDB.
}
\examples{
\dontrun{
src <- src_sqlite()
docdb_create(src, "mtcars", mtcars)
docdb_update(src, "mtcars", value = mtcars[3, 4:5], query = '{"gear": 3}')
docdb_update(src, "mtcars", value = '{"carb":999}', query = '{"gear": 5}')
docdb_update(src, "mtcars", value = '{"_id":"Fiat 128", "carb":888}', query = '{}')
docdb_get(src, "mtcars")
}
}
