% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.R, R/writessh.R
\name{write_pem}
\alias{write_pem}
\alias{write_der}
\alias{write_pkcs1}
\alias{write_ssh}
\alias{write_openssh_pem}
\title{Export key or certificate}
\usage{
write_pem(x, path = NULL, password = NULL)

write_der(x, path = NULL)

write_pkcs1(x, path = NULL, password = NULL)

write_ssh(pubkey, path = NULL)

write_openssh_pem(key, path = NULL)
}
\arguments{
\item{x}{a public/private key or certificate object}

\item{path}{file to write to. If \code{NULL} it returns the output as a string.}

\item{password}{string or callback function to set password (only applicable for
private keys).}

\item{pubkey}{a public key}

\item{key}{a private key}
}
\description{
The \code{write_pem} functions exports a key or certificate to the standard
base64 PEM format. For private keys it is possible to set a password.
}
\details{
The pkcs1 format is the old legacy format used by OpenSSH. PKCS1 does not
support the new ed25519 keys, for which you need \code{write_openssh_pem}.
For non-ssh clients, we recommend to simply use \code{write_pem} to export keys
and certs into the recommended formats.
}
\examples{
# Generate RSA keypair
key <- rsa_keygen()
pubkey <- key$pubkey

# Write to output formats
write_ssh(pubkey)
write_pem(pubkey)
write_pem(key, password = "super secret")
}
