% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/breeding_values.R
\name{breeding_values}
\alias{breeding_values}
\alias{plot.qtlpoly.bvalues}
\title{Prediction of QTL-based breeding values from REMIM model}
\usage{
breeding_values(data, fitted)

\method{plot}{qtlpoly.bvalues}(x, pheno.col = NULL, ...)
}
\arguments{
\item{data}{an object of class \code{qtlpoly.data}.}

\item{fitted}{an object of class \code{qtlpoly.fitted}.}

\item{x}{an object of class \code{qtlpoly.bvalues} to be plotted.}

\item{pheno.col}{a numeric vector with the phenotype column numbers to be plotted; if \code{NULL}, all phenotypes from \code{'data'} will be included.}

\item{...}{currently ignored}
}
\value{
An object of class \code{qtlpoly.bvalues} which is a list of \code{results} for each trait containing the following components:

    \item{pheno.col}{a phenotype column number.}
    \item{y.hat}{a column matrix of breeding value for each individual.}

A \pkg{ggplot2} histogram with the distribution of breeding values.
}
\description{
Computes breeding values for each genotyped individual based on multiple QTL models
}
\examples{
  \donttest{
  # Estimate conditional probabilities using mappoly package
  library(mappoly)
  library(qtlpoly)
  genoprob4x = lapply(maps4x[c(5)], calc_genoprob) #5,7
  data = read_data(ploidy = 4, geno.prob = genoprob4x, pheno = pheno4x, step = 1)

  # Search for QTL
  remim.mod = remim(data = data, pheno.col = 1, w.size = 15, sig.fwd = 0.0011493379,
sig.bwd = 0.0002284465, d.sint = 1.5, n.clusters = 1)

  # Fit model
  fitted.mod = fit_model(data = data, model = remim.mod, probs = "joint", polygenes = "none")

  # Predict genotypic values
  y.hat = breeding_values(data = data, fitted = fitted.mod)
  plot(y.hat)
  }
  
}
\references{
Pereira GS, Gemenet DC, Mollinari M, Olukolu BA, Wood JC, Mosquera V, Gruneberg WJ, Khan A, Buell CR, Yencho GC, Zeng ZB (2020) Multiple QTL mapping in autopolyploids: a random-effect model approach with application in a hexaploid sweetpotato full-sib population, \emph{Genetics} 215 (3): 579-595. \doi{10.1534/genetics.120.303080}.
}
\seealso{
\code{\link[qtlpoly]{read_data}}, \code{\link[qtlpoly]{fit_model}}
}
\author{
Guilherme da Silva Pereira, \email{gdasilv@ncsu.edu}
}
