% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_line.R
\name{PlotLine}
\alias{PlotLine}
\title{Illustrate line chart of treatment ranking metrics}
\usage{
PlotLine(data, accum = NULL, compo = NULL, merge = NULL, color = NULL)
}
\arguments{
\item{data}{DATA of metrics for treatment ranking.}

\item{accum}{LOGIC value for indicating whether use accumulative probabilities.
This parameter is only for probabilities but not global metrics of
treatment ranking.}

\item{compo}{LOGIC value for indicating whether use composite line chart.
This parameter is only for probabilities but not global metrics of
treatment ranking.}

\item{merge}{LOGIC value for indicating whether merge line charts together.}

\item{color}{LIST of colors for treatments in a network meta-analysis,
or CHARACTER of a color for the line on not composite line chart.}
}
\value{
\strong{PlotLine()} returns a line chart.
}
\description{
\strong{PlotLine()} is a function for illustrating line chart in both simple
and composite styles.
}
\examples{
## Not run:
#library(netmeta)
#data(Senn2013)
#nma <- netmeta(TE, seTE, treat1, treat2,
#studlab, data = Senn2013, sm = "SMD")

# Get SUCRA
#dataMetrics <- GetMetrics(nma, outcome = "HbA1c", prefer = "small", metrics = "SUCRA",
#model = "random", simt = 1000)

# Set data for rankinma
#dataRankinma <- SetMetrics(dataMetrics, tx = tx, outcome = outcome,
#metrics = SUCRA, metrics.name = "SUCRA")

# Illustrate bar plot
#PlotLine(dataRankinma)
## End(Not run)

}
\references{
Chaimani, A., Higgins, J. P., Mavridis, D., Spyridonos, P., &
Salanti, G. (2013). Graphical tools for network meta-analysis in STATA.
\strong{PloS one}, \emph{8(10)}, e76654.
}
\seealso{
\code{\link{GetMetrics}}, \code{\link{SetMetrics}},
\code{\link{PlotBeads}}, \code{\link{PlotBar}},
\code{\link{PlotHeat}}, \code{\link{PlotSpie}}
}
\author{
Enoch Kang
}
