% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_metrics.R
\name{SetMetrics}
\alias{SetMetrics}
\title{Setup data of treatment ranking metrics for rankinma}
\usage{
SetMetrics(
  data,
  outcome = NULL,
  tx = NULL,
  metrics = NULL,
  metrics.name = NULL,
  trans = 0.8
)
}
\arguments{
\item{data}{DATAFRAME of treatment, metrics, and name of outcomes.}

\item{outcome}{VARIABLE string data for of outcome(s).}

\item{tx}{VARIABLE with string data for treatments.}

\item{metrics}{VARIABLE with numeric data for global metrics, but it should
be "NULL" when using "Probabilities" as metrics.}

\item{metrics.name}{STRING for metrics of treatment ranking in terms of
"SUCRA" and "P-score" for the value of surface under the cumulative
ranking curve or P-score.}

\item{trans}{NUMERIC for indicating transparency of colors of treatments.}
}
\value{
\strong{SetMetrics()} returns a confirmed data.frame of treatment, metrics of
treatment ranking, and outcome name.
\item{metrics.name}{A string shows type of metrics of treatment ranking.}
\item{ls.outcome}{Strings list outcomes.}
\item{ls.tx}{Strings list treatments.}
\item{n.outcome}{An integer shows numbers of outcomes.}
\item{n.tx}{An integer shows numbers of treatments.}
\item{data}{A data frame consists of seven columns of core information among
all outcomes.}
\item{data.sets}{A list shows data frame of core information by each outcome.}
\item{ptrn.tx}{A data frame shows treatments on each outcome.}
\item{ptrn.outcome}{A data frame shows outcomes by treatments.}
\item{color.txs}{A data frame shows color of each treatment.}
\item{trans}{A numeric value shows transparency for colors of each treatment.}
}
\description{
\strong{SetMetrics()} is a function for checking and preparing data set of metrics
for further ploting in \emph{rankinma}.
}
\examples{
## Not run:
#library(netmeta)
#data(Senn2013)
#nma <- netmeta(TE, seTE, treat1, treat2,
#studlab, data = Senn2013, sm = "SMD")

# Get SUCRA
#nma.1 <- GetMetrics(nma, outcome = "HbA1c.random", prefer = "small", metrics = "SUCRA",
#model = "random", simt = 1000)
#nma.2 <- GetMetrics(nma, outcome = "HbA1c.common", prefer = "small", metrics = "SUCRA",
#model = "common", simt = 1000)

# Combine metrics of multiple outcomes
#dataMetrics <- rbind(nma.1, nma.2)

# Set data for rankinma
#dataRankinma <- SetMetrics(dataMetrics, tx = tx, outcome = outcome,
#metrics = SUCRA, metrics.name = "SUCRA")
## End(Not run)

}
\seealso{
\code{\link{GetMetrics}}
}
