% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setse_shift.R
\name{setse_shift}
\alias{setse_shift}
\title{setse algorithm with automatic timestep adjustment}
\usage{
setse_shift(
  g,
  force = "force",
  distance = "distance",
  edge_name = "edge_name",
  k = "k",
  tstep = 0.02,
  mass = 1,
  max_iter = 20000,
  coef_drag = 1,
  tol = 1e-06,
  sparse = FALSE,
  two_node_solution = TRUE,
  sample = 1,
  static_limit = NULL,
  tstep_change = 0.5
)
}
\arguments{
\item{g}{An igraph object}

\item{force}{A character string. This is the node attribute that contains the force the nodes exert on the network.}

\item{distance}{A character string. The edge attribute that contains the original/horizontal distance between nodes.}

\item{edge_name}{A character string. This is the edge attribute that contains the edge_name of the edges.}

\item{k}{A character string. This is k for the moment don't change it.}

\item{tstep}{A numeric. The time interval used to iterate through the network dynamics.}

\item{mass}{A numeric. This is the mass constant of the nodes in normalised networks this is set to 1.}

\item{max_iter}{An integer. The maximum number of iterations before stopping. Larger networks usually need more iterations.}

\item{coef_drag}{A numeric.}

\item{tol}{A numeric. The tolerance factor for early stopping.}

\item{sparse}{Logical. Whether or not the function should be run using sparse matrices. must match the actual matrix, this could prob be automated}

\item{two_node_solution}{Logical. The Newton-Raphson algo is used to find the correct angle}

\item{sample}{Integer. The dynamics will be stored only if the iteration number is a multiple of the sample. 
This can greatly reduce the size of the results file for large numbers of iterations. Must be a multiple of the max_iter}

\item{static_limit}{Numeric. The maximum value the static force can reach before the algorithm terminates early. This
prevents calculation in a diverging system. The value should be set to some multiple greater than one of the force in the system.
If left blank the static limit is twice the system absolute mean force.}

\item{tstep_change}{a numeric scaler. A value between 0 and one, the fraction the new timestep will be relative to the previous one
this can stop the momentum of the nodes forcing a divergence, but also can slow down the process. default is TRUE.}
}
\value{
A list of three elements. A data frame with the height embeddings of the network, a data frame of the edge embeddings
as well as the convergence dynamics dataframe for the network.
}
\description{
The basic setse function with added timestep adjustment. 
The time shift functionality automatically adjusts the timestep if the convergence process is noisy
}
\details{
This is the basic SETS embeddings algorithm, it outputs all elements of the embeddings as well as convergence dynamics. It is a
wrapper around the core SETS algorithm which requires data preparation and only produces node embeddings and network dynamics. 
There is little reason to use this function as \code{\link{setse_auto}} and \code{\link{setse_bicomp}} 
are faster and easier to use.
}
\examples{
\dontrun{
biconnected_network \%>\%
prepare_continuous_force(., node_names = "name", force_var = "force") \%>\%
#embed the network using setse
setse_shift(., k = "weight", tstep = 0.000029)
}
}
\seealso{
\code{\link{setse_auto}} \code{\link{setse_bicomp}}
}
