% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/documents.R
\name{document_search}
\alias{document_search}
\title{Global search for a term}
\usage{
document_search(
  query,
  ...,
  max_results = 50,
  simplify = T,
  api_key = get_api_key()
)
}
\arguments{
\item{query}{description}

\item{...}{query parameters as documented in
\url{https://community.researchspace.com/public/apiDocs} [GET /documents]
Can be used to order/filter the results.}

\item{max_results}{Maximum number of results to return.}

\item{simplify}{Whether to simplify the returned tibble by converting/removing columns
Use \code{Inf} to return all results (may take a while).}

\item{api_key}{RSpace API key}
}
\value{
A tibble with search results, one result per row.
}
\description{
Global search for a term, works identically to the simple "All" search in RSpace Workspace.
Query term must be >= 3 characters long.
}
