% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtsplot.r
\name{rtsplot.ohlc}
\alias{rtsplot.ohlc}
\title{Create OHLC Plot}
\usage{
rtsplot.ohlc(y, col = rtsplot.theme()$col.border)
}
\arguments{
\item{y}{\code{\link{xts}} object}

\item{col}{color for bars, \strong{defaults to rtsplot.theme()$col.border}}
}
\value{
nothing
}
\description{
Plot ohlc if dx is sufficient otherwise bars
}
\examples{
y = rtsplot.fake.stock.data(50, ohlc=TRUE)
symbol = 'SPY'
	
 # plot
 layout(1)
 rtsplot(y, type = 'n')
 rtsplot.ohlc(y)
rtsplot.legend(symbol, 'black', y)

rtsplot.theme.set(legend.bg.col=grDevices::adjustcolor('blue', 25/255))
rtsplot.corner.label('Logo \uA9', x=1, y=-1, cex = 0.7, space='figure', col='blue')
rtsplot.theme.set(legend.bg.col = grDevices::adjustcolor('white', 200/255))

}
