% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.data.frame.R
\name{as.data.frame.seas}
\alias{as.data.frame.seas}
\alias{as.data.frame.summary.seas}
\title{Coerce Output to \code{data.frame}}
\usage{
\method{as.data.frame}{seas}(x, ...)

\method{as.data.frame}{summary.seas}(x, ...)
}
\arguments{
\item{x}{an object of class \code{"seas"} or
\code{"summary.seas"}, usually, the result of a call to the functions
with the same name.}

\item{...}{unused.}
}
\value{
a \code{data.frame} without row names.
}
\description{
These methods coerce the output to a \code{data.frame}. This is useful for
further processing. (This is a second attempt to do that; the first
experimenal attempt in version 1.4 used an argument \code{data.frame} in the
call to the functions, and is now obsolete. The present approach seems
cleaner and is likely to stay, but still consider it as 
\strong{experimental}.)
}
\details{
The data.frames produced by these functions follow the naming conventions
from the 'broom' package, but do not depend on it otherwise.
}
\examples{
\dontrun{
m <- seas(AirPassengers, x11 = "")

# a data.frame containing data
as.data.frame(m)

# a data.frame containing the summary information on the coefficients
as.data.frame(summary(m))
}
}
