% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{fivebestmdl}
\alias{fivebestmdl}
\title{Five Best ARIMA Models}
\usage{
fivebestmdl(x)
}
\arguments{
\item{x}{object of class \code{"seas"}}
}
\description{
Returns the five best models as chosen by the BIC criterion. It needs the
\code{automdl} spec to be activated (default). If it is not activated, the
function tries to re-evaluate the model with the \code{automdl} spec
activated.
}
\examples{
\dontrun{

m <- seas(AirPassengers)
fivebestmdl(m)
}
}
\references{
Vignette with a more detailed description: 
  \url{http://www.seasonal.website/seasonal.html}
  
  Comprehensive list of R examples from the X-13ARIMA-SEATS manual: 
  \url{http://www.seasonal.website/examples.html}
  
  Official X-13ARIMA-SEATS manual: 
  \url{https://www.census.gov/ts/x13as/docX13ASHTML.pdf}
}
\seealso{
\code{\link{seas}} for the main function.

\code{\link{series}}, for universal X-13 output extraction.

\code{\link{plot.seas}}, for diagnostical plots.

\code{\link{out}}, for accessing the full output of X-13ARIMA-SEATS.
}
