% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics.R
\name{coordtrans}
\alias{coordtrans}
\title{Coordinate-transform azimuth prob distributions into declination prob distributions}
\usage{
coordtrans(pdf, hor, refraction, atm, temp, verbose = T, .res = 0.1)
}
\arguments{
\item{pdf}{A \emph{skyscapeR.pdf} object created with \code{\link{az.pdf}}}

\item{hor}{A \emph{skyscapeR.horizon} object created with \code{\link{createHor}} or \code{\link{downloadHWT}}}

\item{refraction}{(Optional) Whether atmospheric refraction is to be taken into account.
If not given the value set by \code{\link{skyscapeR.vars}} will be used instead.}

\item{atm}{(Optional) Atmospheric pressure for refraction calculation.
If not given the value set by \code{\link{skyscapeR.vars}} will be used instead.}

\item{temp}{(Optional) Atmospheric temperature for refraction calculation.
If not given the value set by \code{\link{skyscapeR.vars}} will be used instead.}

\item{verbose}{(Optional) Boolean to control whether or not to display text. Default is TRUE.}

\item{.res}{(Optional) Declination resolution with which to output probability distribution(s). Default is 0.1 degrees.}
}
\description{
Coordinate-transform azimuth prob distributions into declination prob distributions
}
\examples{
Az <- az.pdf(az=c(87,93,90,110), unc=3)
hor <- createHor(az=c(0,360), alt=c(0,0), loc=c(35,-8,25)) # flat horizon with 0 degrees of altitude
Dec <- coordtrans(Az, hor)
plot(Dec)
}
\references{
Silva, F (2020) A probabilistic framework and significance test for the analysis of structural orientations
 in skyscape archaeology \emph{Journal of Archaeological Science} 118, 105138. <doi:10.1016/j.jas.2020.105138>
}
