% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_pca_partialSVD.R
\name{gt_pca_partialSVD}
\alias{gt_pca_partialSVD}
\title{PCA for \code{gen_tibble} objects by partial SVD}
\usage{
gt_pca_partialSVD(
  x,
  k = 10,
  fun_scaling = bigsnpr::snp_scaleBinom(),
  total_var = TRUE
)
}
\arguments{
\item{x}{a \code{gen_tbl} object}

\item{k}{Number of singular vectors/values to compute. Default is \code{10}.
\strong{This algorithm should be used to compute a few singular vectors/values.}}

\item{fun_scaling}{Usually this  can be left unset, as it defaults to
\code{\link[bigsnpr:snp_scaleBinom]{bigsnpr::snp_scaleBinom()}}, which is the appropriate function for
biallelic SNPs. Alternatively it is possible to use  custom function (see
\code{\link[bigsnpr:snp_autoSVD]{bigsnpr::snp_autoSVD()}} for details.}

\item{total_var}{a boolean indicating whether to compute the total variance
of the matrix. Default is \code{TRUE}. Using \code{FALSE} will speed up computation,
but the total variance will not be stored in the output (and thus it will
not be possible to assign a proportion of variance explained to the
components).}
}
\value{
a \code{gt_pca} object, which is a subclass of \code{bigSVD}; this is an S3
list with elements: A named list (an S3 class "big_SVD") of
\itemize{
\item \code{d}, the eigenvalues (singular values, i.e. as variances),
\item \code{u}, the scores for each sample on each component (the left singular
vectors)
\item \code{v}, the loadings (the right singular vectors)
\item \code{center}, the centering vector,
\item \code{scale}, the scaling vector,
\item \code{method}, a string defining the method (in this case 'partialSVD'),
\item \code{call}, the call that generated the object.
\item \code{square_frobenius}, used to compute the proportion of variance explained
by the components (optional)

Note: rather than accessing these elements directly, it is better to use
\code{tidy} and \code{augment}. See \code{\link{gt_pca_tidiers}}.
}
}
\description{
This function performs Principal Component Analysis on a \code{gen_tibble}, by
partial SVD through the eigen decomposition of the covariance. It works well
if the number of individuals is much smaller than the number of loci;
otherwise, \code{\link[=gt_pca_randomSVD]{gt_pca_randomSVD()}} is a better option. This function is a
wrapper for \code{\link[bigstatsr:big_SVD]{bigstatsr::big_SVD()}}.
}
\examples{
# Create a gen_tibble of lobster genotypes
bed_file <-
  system.file("extdata", "lobster", "lobster.bed", package = "tidypopgen")
lobsters <- gen_tibble(bed_file,
  backingfile = tempfile("lobsters"),
  quiet = TRUE
)

# Remove monomorphic loci and impute
lobsters <- lobsters \%>\% select_loci_if(loci_maf(genotypes) > 0)
lobsters <- gt_impute_simple(lobsters, method = "mode")

# Create PCA object, including total variance
gt_pca_partialSVD(lobsters,
  k = 10,
  total_var = TRUE
)
# Change number of components and exclude total variance
gt_pca_partialSVD(lobsters,
  k = 5,
  total_var = FALSE
)
}
