% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snp_ibs.R
\name{snp_ibs}
\alias{snp_ibs}
\title{Compute the Identity by State Matrix for a bigSNP object}
\usage{
snp_ibs(
  X,
  ind.row = bigstatsr::rows_along(X),
  ind.col = bigstatsr::cols_along(X),
  type = c("proportion", "adjusted_counts", "raw_counts"),
  block.size = bigstatsr::block_size(nrow(X))
)
}
\arguments{
\item{X}{a \link[bigstatsr:FBM.code256-class]{bigstatsr::FBM.code256} matrix (as found in the \code{genotypes} slot
of a \link[bigsnpr:bigSNP-class]{bigsnpr::bigSNP} object).}

\item{ind.row}{An optional vector of the row indices that are used. If not
specified, all rows are used. Don't use negative indices.}

\item{ind.col}{An optional vector of the column indices that are used. If not
specified, all columns are used. Don't use negative indices.}

\item{type}{one of "proportion" (equivalent to "ibs" in PLINK),
"adjusted_counts" ("distance" in PLINK), and "raw_counts" (the counts of
identical alleles and non-missing alleles, from which the two other
quantities are computed)}

\item{block.size}{maximum number of columns read at once. Note that, to
optimise the speed of matrix operations, we have to store in memory 3 times
the columns.}
}
\value{
if as.counts = TRUE function returns a list of two \link[bigstatsr:FBM-class]{bigstatsr::FBM}
matrices, one of counts of IBS by alleles (i.e. 2*n loci), and one of valid
alleles (i.e. 2 * n_loci - 2 * missing_loci). If as.counts = FALSE returns
a single matrix of IBS proportions.
}
\description{
This function computes the IBS matrix.
}
\details{
Note that monomorphic sites are currently counted. Should we filter them
beforehand? What does plink do?
}
\examples{
example_gt <- load_example_gt("gen_tbl")

X <- attr(example_gt$genotypes, "bigsnp")
snp_ibs(X$genotypes)

# Compute for individuals 1 to 5
snp_ibs(X$genotypes, ind.row = 1:5, ind.col = 1:5)

# Adjust block.size
snp_ibs(X$genotypes, block.size = 2)

# Change type
snp_ibs(X$genotypes, type = "proportion")
snp_ibs(X$genotypes, type = "adjusted_counts")
snp_ibs(X$genotypes, type = "raw_counts")

}
