% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset-fer.R
\name{fer_dataset}
\alias{fer_dataset}
\title{FER-2013 Facial Expression Dataset}
\usage{
fer_dataset(
  root = tempdir(),
  train = TRUE,
  transform = NULL,
  target_transform = NULL,
  download = FALSE
)
}
\arguments{
\item{root}{(string, optional): Root directory for dataset storage,
the dataset will be stored under \code{root/fer2013}.}

\item{train}{Logical. If TRUE, use the training set; otherwise, use the test set. Not applicable to all datasets.}

\item{transform}{Optional. A function that takes an image and returns a transformed version (e.g., normalization, cropping).}

\item{target_transform}{Optional. A function that transforms the label.}

\item{download}{Logical. If TRUE, downloads the dataset to \verb{root/}. If the dataset is already present, download is skipped.}
}
\value{
A torch dataset of class \code{fer_dataset}.
Each element is a named list:
\itemize{
\item \code{x}: a 48x48 grayscale array
\item \code{y}: an integer from 1 to 7 indicating the class index
}
}
\description{
Loads the FER-2013 dataset for facial expression recognition. The dataset contains grayscale images
(48x48) of human faces, each labeled with one of seven emotion categories:
\code{"Angry"}, \code{"Disgust"}, \code{"Fear"}, \code{"Happy"}, \code{"Sad"}, \code{"Surprise"}, and \code{"Neutral"}.
}
\details{
The dataset is split into:
\itemize{
\item \code{"Train"}: training images labeled as \code{"Training"} in the original CSV.
\item \code{"Test"}: includes both \code{"PublicTest"} and \code{"PrivateTest"} entries.
}
}
\examples{
\dontrun{
fer <- fer_dataset(train = TRUE, download = TRUE)
first_item <- fer[1]
first_item$x  # 48x48 grayscale array
first_item$y  # 4
fer$classes[first_item$y]  # "Happy"
}

}
\seealso{
Other classification_dataset: 
\code{\link{caltech_dataset}},
\code{\link{cifar10_dataset}()},
\code{\link{eurosat_dataset}()},
\code{\link{fgvc_aircraft_dataset}()},
\code{\link{flowers102_dataset}()},
\code{\link{mnist_dataset}()},
\code{\link{oxfordiiitpet_dataset}()},
\code{\link{tiny_imagenet_dataset}()}
}
\concept{classification_dataset}
