% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_vcf.R
\name{read_vcf}
\alias{read_vcf}
\title{VCF Data Input}
\usage{
read_vcf(fn, vcffor, dbOnly = FALSE, depCut = FALSE, thred = 20,
  metaline = 200, extnum = 10, keepall = TRUE, filter = FALSE)
}
\arguments{
\item{fn}{Input vcf file name}

\item{vcffor}{Input vcf data format: 1) GATK; 2) VarPROWL; 3) VarDict; 4) strelka2}

\item{dbOnly}{Use dbSNP as filter, default is FALSE}

\item{depCut}{Use a threshold for min depth , default is False}

\item{thred}{Threshold for min depth, default is 20}

\item{metaline}{Number of head lines to read in (better to be large enough), the lines will be checked if they contain meta information, default is 200}

\item{extnum}{The column number to be extracted from vcf, default is 10; 0 for not extracting any column; extnum should be between 10 and total column number}

\item{keepall}{Keep unextracted column in output, default is TRUE}

\item{filter}{Whether to select "PASS" variants for analyses if they contain unfiltered variants, default is FALSE}
}
\value{
A list containing (1) Content: a vector showing what is contained; (2) Meta: a data frame containing meta-information of the file;
(3) VCF: a data frame, the main part of VCF file; (4) file_sample_name: the file name and sample name,
in case when multiple samples exist in one file, file and sample names might be different
}
\description{
Reads a file in vcf or vcf.gz file and creates a list containing Content, Meta, VCF and file_sample_name
}
\examples{
file.name <- system.file("extdata", "example.vcf.gz", package = "vanquish")
example <- read_vcf(fn=file.name, vcffor="VarPROWL")
}
