% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AdaptiveBoxplot.R
\name{bh_boxplot}
\alias{bh_boxplot}
\title{False Discovery Rate (FDR) Boxplot}
\usage{
bh_boxplot(data, alpha = 0.01, group_col = NULL, value_col = NULL, ...)
}
\arguments{
\item{data}{A numeric vector for a single boxplot, or a data frame for grouped boxplots.}

\item{alpha}{The target FDR level. Defaults to 0.01.}

\item{group_col}{A string specifying the name of the grouping column in `data`.}

\item{value_col}{A string specifying the name of the value column in `data`.}

\item{...}{Additional arguments passed to the base \code{\link[graphics]{boxplot}} function.}
}
\value{
A plot is drawn on the current graphics device.
}
\description{
Generates a boxplot where whisker lengths are determined by the Benjamini-Hochberg
procedure to control the False Discovery Rate (FDR), making the outlier
detection rule adaptive to sample size and data characteristics.
}
\details{
This function is a graphical implementation of the p-value pipeline
proposed by Gang, Lin, and Tong (2025). It uses robust estimators for the
mean and standard deviation based on quartiles to calculate p-values for each
observation, then applies the Benjamini-Hochberg (BH) procedure to determine
an adaptive p-value threshold for outlier detection. Outliers are points
falling beyond the fences defined by this threshold.
}
\examples{
# Single group example
set.seed(123)
data_single <- c(rnorm(50), 10, 12)
bh_boxplot(data_single, alpha = 0.05, main = "FDR Boxplot (Single Group)")

# Grouped data example
data_grouped <- data.frame(
  Category = rep(c("A", "B"), each = 100),
  Value = c(rnorm(100), rnorm(100, mean = 2, sd = 1.5))
)
bh_boxplot(data_grouped, group_col = "Category", value_col = "Value")
}
\references{
Gang, B., Lin, H., & Tong, T. (2025). Unifying Boxplots: A Multiple Testing Perspective.
}
\seealso{
\code{\link{holm_boxplot}}
}
