% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Simulation.R
\name{Simulation}
\alias{Simulation}
\title{R6 class Create and represent a Simulation object}
\description{
The \link{Simulation} class inherits the \link{Population} class. So a simulation
manages agents and their contact. Thus, the class also inherits the
\link{Agent} class. So a simulation can have its own state, and events attached
(scheduled) to it. In addition, it also manages all the transitions, using
its \code{addTransition} method. ASt last, it maintains loggers, which
record (or count) the state changes, and report their values at specified
times.
}
\section{Super classes}{
\code{ABM::R6Agent} -> \code{ABM::R6Population} -> \code{R6Simulation}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-R6Simulation-new}{\code{Simulation$new()}}
\item \href{#method-R6Simulation-run}{\code{Simulation$run()}}
\item \href{#method-R6Simulation-resume}{\code{Simulation$resume()}}
\item \href{#method-R6Simulation-addLogger}{\code{Simulation$addLogger()}}
\item \href{#method-R6Simulation-addTransition}{\code{Simulation$addTransition()}}
\item \href{#method-R6Simulation-clone}{\code{Simulation$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="ABM" data-topic="R6Agent" data-id="leave"><a href='../../ABM/html/R6Agent.html#method-R6Agent-leave'><code>ABM::R6Agent$leave()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ABM" data-topic="R6Agent" data-id="match"><a href='../../ABM/html/R6Agent.html#method-R6Agent-match'><code>ABM::R6Agent$match()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ABM" data-topic="R6Agent" data-id="schedule"><a href='../../ABM/html/R6Agent.html#method-R6Agent-schedule'><code>ABM::R6Agent$schedule()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ABM" data-topic="R6Agent" data-id="setDeathTime"><a href='../../ABM/html/R6Agent.html#method-R6Agent-setDeathTime'><code>ABM::R6Agent$setDeathTime()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ABM" data-topic="R6Agent" data-id="unschedule"><a href='../../ABM/html/R6Agent.html#method-R6Agent-unschedule'><code>ABM::R6Agent$unschedule()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ABM" data-topic="R6Population" data-id="addAgent"><a href='../../ABM/html/R6Population.html#method-R6Population-addAgent'><code>ABM::R6Population$addAgent()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ABM" data-topic="R6Population" data-id="addContact"><a href='../../ABM/html/R6Population.html#method-R6Population-addContact'><code>ABM::R6Population$addContact()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ABM" data-topic="R6Population" data-id="agent"><a href='../../ABM/html/R6Population.html#method-R6Population-agent'><code>ABM::R6Population$agent()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ABM" data-topic="R6Population" data-id="removeAgent"><a href='../../ABM/html/R6Population.html#method-R6Population-removeAgent'><code>ABM::R6Population$removeAgent()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ABM" data-topic="R6Population" data-id="setState"><a href='../../ABM/html/R6Population.html#method-R6Population-setState'><code>ABM::R6Population$setState()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ABM" data-topic="R6Population" data-id="setStates"><a href='../../ABM/html/R6Population.html#method-R6Population-setStates'><code>ABM::R6Population$setStates()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-R6Simulation-new"></a>}}
\if{latex}{\out{\hypertarget{method-R6Simulation-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Simulation$new(simulation = 0, initializer = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{simulation}}{can be either an external pointer pointing to
a population object returned from newSimulation, or an integer
specifying the population size, or a list}

\item{\code{initializer}}{a function or NULL}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
If simulation is a number (the population size), then initializer
can be a function that take the index of an agent and return its initial
state. If it is a list, the length is the population size, and each element
corresponds to the initial state of an agent (with the same index).
Run the simulation
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-R6Simulation-run"></a>}}
\if{latex}{\out{\hypertarget{method-R6Simulation-run}{}}}
\subsection{Method \code{run()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Simulation$run(time)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{time}}{the time points to return the logger values.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
the returned list can be coerced into a data.frame object
which first column is time, and other columns are logger results,
each row corresponds to a time point.

The Simulation object first collect and log the states from all
agents in the simulation, then set the current time to the time of
the first event, then call the resume method to actually run it.

Continue running the simulation
}

\subsection{Returns}{
a list of numeric vectors, with time and values reported
by all logger.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-R6Simulation-resume"></a>}}
\if{latex}{\out{\hypertarget{method-R6Simulation-resume}{}}}
\subsection{Method \code{resume()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Simulation$resume(time)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{time}}{the time points to return the logger values.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
the returned list can be coerced into a data.frame object
which first column is time, and other columns are logger results,
each row corresponds to a time point.

The Simulation object repetitively handle the events until the the
last time point in "time" is reached. ASt each time point, the
logger states are collected in put in a list to return.
Add a logger to the simulation
}

\subsection{Returns}{
a list of numeric vectors, with time and values reported
by all logger.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-R6Simulation-addLogger"></a>}}
\if{latex}{\out{\hypertarget{method-R6Simulation-addLogger}{}}}
\subsection{Method \code{addLogger()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Simulation$addLogger(logger)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{logger, }}{an external pointer returned by functions like
newCounter or newStateLogger.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
without adding a logger, there will be no useful simulation
results returned.
Add a transition to the simulation
}

\subsection{Returns}{
the exactly same value as sim.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-R6Simulation-addTransition"></a>}}
\if{latex}{\out{\hypertarget{method-R6Simulation-addTransition}{}}}
\subsection{Method \code{addTransition()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Simulation$addTransition(
  rule,
  waiting.time,
  to_change_callback = NULL,
  changed_callback = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rule}}{is a formula that gives the transition rule}

\item{\code{waiting.time}}{either an external pointer to a WaitingTime object
such as one returned by newExpWaitingTime or newGammaWaitingTime, or
a function (see the details section)}

\item{\code{to_change_callback}}{the R callback function to determine if
the change should occur. See the details section.}

\item{\code{changed_callback}}{the R callback function after the change
happened. See the details section.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
If waiting.time is a function then it should take exactly one
argument time, which is a numeric value holding the current value, and
return a single numeric value for the waiting time (i.e., should not add
time).

Formula can be used to specify either a spontaneous
transition change, or a transition caused by a contact.

A spontaneous transition has the form from -> to, where from and
to are state specifications. It is either a variable name holding
a state (R list) or the list itself. The list can also be specified
by state(...) instead of list(...)

For a spontaneous transition, the callback functions take the
following two arguments
\enumerate{
\item time: the current time in the simulation
\item agent: the agent who initiate the contact, an external pointer
}

A transition caused by contact, the formula needs to specify the
states of both the agent who initiate the contact and the contact
agent. The two states are connected by a + sign, the one before the
\itemize{
\item sign is the initiator, and the one after the sign is the contact.
The transition must be associated with a Contact object, using
a ~ operator. The Contact object must be specified by a variable name
that hold the external pointer to the object (created by e.g.,
the newRandomMixing function) For example, suppose S=list("S"),
I=list("I"), and m=newRandomMixing(sim), then a possible rule
specifying an infectious agent contacting a susceptible agent causing
it to become exposed can be
specified by
}

I + S -> I + list("E") ~ m

For a transition caused by a contact, the callback functions take
the third argument:
3. contact: the contact agent, an external pointer
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-R6Simulation-clone"></a>}}
\if{latex}{\out{\hypertarget{method-R6Simulation-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Simulation$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
